/*
 * Decompiled with CFR 0.152.
 */
package COSE;

import COSE.AlgorithmID;
import COSE.CoseException;
import COSE.ECPrivateKey;
import COSE.ECPublicKey;
import COSE.KeyKeys;
import com.upokecenter.cbor.CBORObject;
import com.upokecenter.cbor.CBORType;
import java.io.IOException;
import java.security.PrivateKey;
import java.security.PublicKey;
import org.bouncycastle.asn1.nist.NISTNamedCurves;
import org.bouncycastle.asn1.x9.X9ECParameters;
import org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.bouncycastle.crypto.KeyGenerationParameters;
import org.bouncycastle.crypto.generators.ECKeyPairGenerator;
import org.bouncycastle.crypto.params.ECDomainParameters;
import org.bouncycastle.crypto.params.ECKeyGenerationParameters;
import org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import org.bouncycastle.crypto.params.ECPublicKeyParameters;

public class OneKey {
    protected CBORObject keyMap;
    private Object UserData;

    public OneKey() {
        this.keyMap = CBORObject.NewMap();
    }

    public OneKey(CBORObject keyData) throws CoseException {
        if (keyData.getType() != CBORType.Map) {
            throw new CoseException("Key data is malformed");
        }
        this.keyMap = keyData;
        this.CheckKeyState();
    }

    public void add(KeyKeys keyValue, CBORObject value) {
        this.keyMap.Add((Object)keyValue.AsCBOR(), (Object)value);
    }

    public void add(CBORObject keyValue, CBORObject value) {
        this.keyMap.Add((Object)keyValue, (Object)value);
    }

    public CBORObject get(KeyKeys keyValue) {
        return this.keyMap.get(keyValue.AsCBOR());
    }

    public CBORObject get(CBORObject keyValue) throws CoseException {
        if (keyValue.getType() != CBORType.Number && keyValue.getType() != CBORType.TextString) {
            throw new CoseException("keyValue type is incorrect");
        }
        return this.keyMap.get(keyValue);
    }

    public boolean HasAlgorithmID(AlgorithmID algorithmId) {
        CBORObject thatObj;
        CBORObject thisObj = this.get(KeyKeys.Algorithm);
        CBORObject cBORObject = thatObj = algorithmId == null ? null : algorithmId.AsCBOR();
        boolean result = thatObj == null ? thisObj == null : thatObj.equals(thisObj);
        return result;
    }

    public boolean HasKeyID(String id) {
        CBORObject thatObj = id == null ? null : CBORObject.FromObject((String)id);
        CBORObject thisObj = this.get(KeyKeys.KeyId);
        boolean result = thatObj == null ? thisObj == null : thatObj.equals(thisObj);
        return result;
    }

    public boolean HasKeyType(CBORObject keyTypeObj) {
        CBORObject thatObj = keyTypeObj;
        CBORObject thisObj = this.get(KeyKeys.KeyType);
        boolean result = thatObj == null ? thisObj == null : thatObj.equals(thisObj);
        return result;
    }

    public boolean HasKeyOp(Integer that) {
        boolean result;
        block3: {
            CBORObject thisObj;
            block4: {
                block2: {
                    thisObj = this.get(KeyKeys.Key_Ops);
                    if (that != null) break block2;
                    result = thisObj == null;
                    break block3;
                }
                result = false;
                if (thisObj.getType() != CBORType.Number) break block4;
                if (thisObj.AsInt32() != that.intValue()) break block3;
                result = true;
                break block3;
            }
            if (thisObj.getType() == CBORType.Array) {
                for (int i = 0; i < thisObj.size(); ++i) {
                    if (thisObj.get(i).getType() != CBORType.Number || thisObj.get(i).AsInt32() != that.intValue()) continue;
                    result = true;
                    break;
                }
            }
        }
        return result;
    }

    private void CheckKeyState() throws CoseException {
        CBORObject val = this.get(KeyKeys.KeyType);
        if (val == null || val.getType() != CBORType.Number) {
            throw new CoseException("Missing or incorrect key type field");
        }
        if (val.equals(KeyKeys.KeyType_Octet)) {
            val = this.get(KeyKeys.Octet_K);
            if (val == null || val.getType() != CBORType.ByteString) {
                throw new CoseException("Malformed key structure");
            }
        } else if (val.equals(KeyKeys.KeyType_EC2)) {
            boolean privateKey = false;
            val = this.get(KeyKeys.EC2_D);
            if (val != null) {
                if (val.getType() != CBORType.ByteString) {
                    throw new CoseException("Malformed key structure");
                }
                privateKey = true;
            }
            if ((val = this.get(KeyKeys.EC2_X)) == null ? !privateKey : val.getType() != CBORType.ByteString) {
                throw new CoseException("Malformed key structure");
            }
            val = this.get(KeyKeys.EC2_Y);
            if (val == null ? !privateKey : val.getType() != CBORType.ByteString && val.getType() != CBORType.Boolean) {
                throw new CoseException("Malformed key structure");
            }
        } else {
            throw new CoseException("Unsupported key type");
        }
    }

    public X9ECParameters GetCurve() throws CoseException {
        if (this.get(KeyKeys.KeyType) != KeyKeys.KeyType_EC2) {
            throw new CoseException("Not an EC2 key");
        }
        CBORObject cnCurve = this.get(KeyKeys.EC2_Curve);
        if (cnCurve == KeyKeys.EC2_P256) {
            return NISTNamedCurves.getByName((String)"P-256");
        }
        if (cnCurve == KeyKeys.EC2_P384) {
            return NISTNamedCurves.getByName((String)"P-384");
        }
        if (cnCurve == KeyKeys.EC2_P521) {
            return NISTNamedCurves.getByName((String)"P-521");
        }
        throw new CoseException("Unsupported curve " + cnCurve);
    }

    public static OneKey generateKey(AlgorithmID algorithm) throws CoseException {
        OneKey returnThis = null;
        switch (algorithm) {
            case ECDSA_256: {
                returnThis = OneKey.generateECDSAKey("P-256", KeyKeys.EC2_P256);
                break;
            }
            case ECDSA_384: {
                returnThis = OneKey.generateECDSAKey("P-384", KeyKeys.EC2_P384);
                break;
            }
            case ECDSA_512: {
                returnThis = OneKey.generateECDSAKey("P-521", KeyKeys.EC2_P521);
                break;
            }
            default: {
                throw new CoseException("Unknown algorithm");
            }
        }
        returnThis.add(KeyKeys.Algorithm, algorithm.AsCBOR());
        return returnThis;
    }

    private static OneKey generateECDSAKey(String curveName, CBORObject curve) {
        X9ECParameters p = NISTNamedCurves.getByName((String)curveName);
        ECDomainParameters parameters = new ECDomainParameters(p.getCurve(), p.getG(), p.getN(), p.getH());
        ECKeyPairGenerator pGen = new ECKeyPairGenerator();
        ECKeyGenerationParameters genParam = new ECKeyGenerationParameters(parameters, null);
        pGen.init((KeyGenerationParameters)genParam);
        AsymmetricCipherKeyPair p1 = pGen.generateKeyPair();
        ECPublicKeyParameters keyPublic = (ECPublicKeyParameters)p1.getPublic();
        ECPrivateKeyParameters keyPrivate = (ECPrivateKeyParameters)p1.getPrivate();
        byte[] rgbX = keyPublic.getQ().normalize().getXCoord().getEncoded();
        byte[] rgbY = keyPublic.getQ().normalize().getYCoord().getEncoded();
        boolean signY = true;
        byte[] rgbD = keyPrivate.getD().toByteArray();
        OneKey key = new OneKey();
        key.add(KeyKeys.KeyType, KeyKeys.KeyType_EC2);
        key.add(KeyKeys.EC2_Curve, curve);
        key.add(KeyKeys.EC2_X, CBORObject.FromObject((byte[])rgbX));
        key.add(KeyKeys.EC2_Y, CBORObject.FromObject((byte[])rgbY));
        key.add(KeyKeys.EC2_D, CBORObject.FromObject((byte[])rgbD));
        return key;
    }

    public OneKey PublicKey() {
        OneKey newKey = new OneKey();
        CBORObject val = this.get(KeyKeys.KeyType);
        if (val.equals(KeyKeys.KeyType_Octet)) {
            return null;
        }
        if (!val.equals(KeyKeys.KeyType_EC2)) {
            return null;
        }
        newKey.add(KeyKeys.EC2_Curve, this.get(KeyKeys.EC2_Curve));
        newKey.add(KeyKeys.EC2_X, this.get(KeyKeys.EC2_X));
        newKey.add(KeyKeys.EC2_Y, this.get(KeyKeys.EC2_Y));
        for (CBORObject obj : this.keyMap.getKeys()) {
            val = this.keyMap.get(obj);
            if (obj.getType() == CBORType.Number) {
                if (obj.AsInt32() <= 0) continue;
                newKey.add(obj, val);
                continue;
            }
            if (obj.getType() != CBORType.TextString) continue;
            newKey.add(obj, val);
        }
        return newKey;
    }

    public byte[] EncodeToBytes() {
        return this.keyMap.EncodeToBytes();
    }

    public CBORObject AsCBOR() {
        return this.keyMap;
    }

    public PublicKey AsPublicKey() throws CoseException {
        if (this.get(KeyKeys.KeyType).equals(KeyKeys.KeyType_EC2)) {
            try {
                return new ECPublicKey(this);
            }
            catch (IOException e) {
                throw new CoseException("Internal Error encoding the key");
            }
        }
        throw new CoseException("Cannot convert key as key type is not converted");
    }

    public PrivateKey AsPrivateKey() throws CoseException {
        if (this.get(KeyKeys.KeyType).equals(KeyKeys.KeyType_EC2)) {
            try {
                return new ECPrivateKey(this);
            }
            catch (IOException ex) {
                throw new CoseException("Internal error encoding the key");
            }
        }
        throw new CoseException("Cannot convert key as key type is not converted");
    }

    public Object getUserData() {
        return this.UserData;
    }

    public void setUserData(Object newData) {
        this.UserData = newData;
    }
}

