/*
 * Decompiled with CFR 0.152.
 */
package COSE;

import COSE.AlgorithmID;
import COSE.CoseException;
import COSE.HeaderKeys;
import COSE.KeyKeys;
import COSE.Message;
import COSE.OneKey;
import com.upokecenter.cbor.CBORObject;
import com.upokecenter.cbor.CBORType;
import java.math.BigInteger;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.List;
import org.bouncycastle.asn1.x9.X9ECParameters;
import org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.KeyGenerationParameters;
import org.bouncycastle.crypto.agreement.ECDHBasicAgreement;
import org.bouncycastle.crypto.digests.SHA256Digest;
import org.bouncycastle.crypto.digests.SHA512Digest;
import org.bouncycastle.crypto.engines.AESWrapEngine;
import org.bouncycastle.crypto.generators.ECKeyPairGenerator;
import org.bouncycastle.crypto.macs.HMac;
import org.bouncycastle.crypto.params.ECDomainParameters;
import org.bouncycastle.crypto.params.ECKeyGenerationParameters;
import org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import org.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.math.ec.ECPoint;
import org.bouncycastle.util.BigIntegers;

public class Recipient
extends Message {
    OneKey privateKey;
    private OneKey senderKey;
    byte[] rgbEncrypted;
    List<Recipient> recipientList;

    @Override
    public void DecodeFromCBORObject(CBORObject objRecipient) throws CoseException {
        if (objRecipient.size() != 3 && objRecipient.size() != 4) {
            throw new CoseException("Invalid Recipient structure");
        }
        if (objRecipient.get(0).getType() == CBORType.ByteString) {
            this.objProtected = objRecipient.get(0).GetByteString().length == 0 ? CBORObject.NewMap() : CBORObject.DecodeFromBytes((byte[])objRecipient.get(0).GetByteString());
        } else {
            throw new CoseException("Invalid Recipient structure");
        }
        if (objRecipient.get(1).getType() != CBORType.Map) {
            throw new CoseException("Invalid Recipient structure");
        }
        this.objUnprotected = objRecipient.get(1);
        if (objRecipient.get(2).getType() != CBORType.ByteString) {
            throw new CoseException("Invalid Recipient structure");
        }
        this.rgbEncrypted = objRecipient.get(2).GetByteString();
        if (objRecipient.size() == 4) {
            if (objRecipient.get(3).getType() == CBORType.Array) {
                this.recipientList = new ArrayList<Recipient>();
                for (int i = 0; i < objRecipient.get(3).size(); ++i) {
                    Recipient recipX = new Recipient();
                    recipX.DecodeFromCBORObject(objRecipient.get(3).get(i));
                    this.recipientList.add(recipX);
                }
            } else {
                throw new CoseException("Invalid Recipient structure");
            }
        }
    }

    @Override
    protected CBORObject EncodeCBORObject() throws CoseException {
        CBORObject obj = CBORObject.NewArray();
        if (this.objProtected.size() > 0) {
            obj.Add((Object)this.objProtected.EncodeToBytes());
        } else {
            obj.Add(CBORObject.FromObject((byte[])new byte[0]));
        }
        obj.Add(this.objUnprotected);
        obj.Add((Object)this.rgbEncrypted);
        if (this.recipientList != null) {
            CBORObject objR = CBORObject.NewArray();
            for (Recipient r : this.recipientList) {
                objR.Add(r.EncodeCBORObject());
            }
            obj.Add(objR);
        }
        return obj;
    }

    public byte[] decrypt(AlgorithmID algCEK, Recipient recip) throws CoseException, InvalidCipherTextException {
        AlgorithmID alg = AlgorithmID.FromCBOR(this.findAttribute(HeaderKeys.Algorithm));
        byte[] rgbKey = null;
        if (recip != this) {
            for (Recipient r : this.recipientList) {
                if (recip == r) {
                    rgbKey = r.decrypt(alg, recip);
                    if (rgbKey != null) break;
                    throw new CoseException("Internal error");
                }
                if (r.recipientList.isEmpty() || (rgbKey = r.decrypt(alg, recip)) == null) continue;
                break;
            }
        }
        switch (alg) {
            case Direct: {
                if (this.privateKey.get(KeyKeys.KeyType.AsCBOR()) != KeyKeys.KeyType_Octet) {
                    throw new CoseException("Mismatch of algorithm and key");
                }
                return this.privateKey.get(KeyKeys.Octet_K.AsCBOR()).GetByteString();
            }
            case HKDF_HMAC_SHA_256: {
                if (this.privateKey.get(KeyKeys.KeyType.AsCBOR()) != KeyKeys.KeyType_Octet) {
                    throw new CoseException("Needs to be an octet key");
                }
                return this.HKDF(this.privateKey.get(KeyKeys.Octet_K.AsCBOR()).GetByteString(), algCEK.getKeySize(), algCEK, (Digest)new SHA256Digest());
            }
            case HKDF_HMAC_SHA_512: {
                if (this.privateKey.get(KeyKeys.KeyType.AsCBOR()) != KeyKeys.KeyType_Octet) {
                    throw new CoseException("Needs to be an octet key");
                }
                return this.HKDF(this.privateKey.get(KeyKeys.Octet_K.AsCBOR()).GetByteString(), algCEK.getKeySize(), algCEK, (Digest)new SHA512Digest());
            }
            case AES_KW_128: 
            case AES_KW_192: 
            case AES_KW_256: {
                if (rgbKey == null) {
                    if (this.privateKey.get(KeyKeys.KeyType.AsCBOR()) != KeyKeys.KeyType_Octet) {
                        throw new CoseException("Key and algorithm do not agree");
                    }
                    rgbKey = this.privateKey.get(KeyKeys.Octet_K.AsCBOR()).GetByteString();
                } else if (this.privateKey != null) {
                    throw new CoseException("Key and algorithm do not agree");
                }
                return this.AES_KeyWrap_Decrypt(alg, rgbKey);
            }
            case ECDH_ES_HKDF_256: 
            case ECDH_SS_HKDF_256: {
                if (this.privateKey.get(KeyKeys.KeyType.AsCBOR()) != KeyKeys.KeyType_EC2) {
                    throw new CoseException("Key and algorithm do not agree");
                }
                rgbKey = this.ECDH_GenerateSecret(this.privateKey);
                return this.HKDF(rgbKey, algCEK.getKeySize(), algCEK, (Digest)new SHA256Digest());
            }
            case ECDH_ES_HKDF_512: 
            case ECDH_SS_HKDF_512: {
                if (this.privateKey.get(KeyKeys.KeyType.AsCBOR()) != KeyKeys.KeyType_EC2) {
                    throw new CoseException("Key and algorithm do not agree");
                }
                rgbKey = this.ECDH_GenerateSecret(this.privateKey);
                return this.HKDF(rgbKey, algCEK.getKeySize(), algCEK, (Digest)new SHA512Digest());
            }
            case ECDH_ES_HKDF_256_AES_KW_128: 
            case ECDH_SS_HKDF_256_AES_KW_128: {
                if (this.privateKey.get(KeyKeys.KeyType.AsCBOR()) != KeyKeys.KeyType_EC2) {
                    throw new CoseException("Key and algorithm do not agree");
                }
                rgbKey = this.ECDH_GenerateSecret(this.privateKey);
                rgbKey = this.HKDF(rgbKey, 128, AlgorithmID.AES_KW_128, (Digest)new SHA256Digest());
                return this.AES_KeyWrap_Decrypt(AlgorithmID.AES_KW_128, rgbKey);
            }
            case ECDH_ES_HKDF_256_AES_KW_192: 
            case ECDH_SS_HKDF_256_AES_KW_192: {
                if (this.privateKey.get(KeyKeys.KeyType.AsCBOR()) != KeyKeys.KeyType_EC2) {
                    throw new CoseException("Key and algorithm do not agree");
                }
                rgbKey = this.ECDH_GenerateSecret(this.privateKey);
                rgbKey = this.HKDF(rgbKey, 192, AlgorithmID.AES_KW_192, (Digest)new SHA256Digest());
                return this.AES_KeyWrap_Decrypt(AlgorithmID.AES_KW_192, rgbKey);
            }
            case ECDH_ES_HKDF_256_AES_KW_256: 
            case ECDH_SS_HKDF_256_AES_KW_256: {
                if (this.privateKey.get(KeyKeys.KeyType.AsCBOR()) != KeyKeys.KeyType_EC2) {
                    throw new CoseException("Key and algorithm do not agree");
                }
                rgbKey = this.ECDH_GenerateSecret(this.privateKey);
                rgbKey = this.HKDF(rgbKey, 256, AlgorithmID.AES_KW_256, (Digest)new SHA256Digest());
                return this.AES_KeyWrap_Decrypt(AlgorithmID.AES_KW_256, rgbKey);
            }
        }
        throw new CoseException("Unsupported Recipent Algorithm");
    }

    public void encrypt() throws CoseException, Exception {
        SecureRandom random;
        AlgorithmID alg = AlgorithmID.FromCBOR(this.findAttribute(HeaderKeys.Algorithm));
        byte[] rgbKey = null;
        int recipientTypes = 0;
        if (this.recipientList != null && !this.recipientList.isEmpty()) {
            if (this.privateKey != null) {
                throw new CoseException("Cannot have dependent recipients if key is specified");
            }
            block14: for (Recipient r : this.recipientList) {
                switch (r.getRecipientType()) {
                    case 1: {
                        if ((recipientTypes & 1) != 0) {
                            throw new CoseException("Cannot have two direct recipients");
                        }
                        recipientTypes |= 1;
                        rgbKey = r.getKey(alg);
                        continue block14;
                    }
                }
                recipientTypes |= 2;
            }
        }
        if (recipientTypes == 3) {
            throw new CoseException("Do not mix direct and indirect recipients");
        }
        if (recipientTypes == 2) {
            rgbKey = new byte[alg.getKeySize() / 8];
            random = new SecureRandom();
            random.nextBytes(rgbKey);
        }
        switch (alg) {
            case Direct: 
            case HKDF_HMAC_SHA_256: 
            case HKDF_HMAC_SHA_512: {
                this.rgbEncrypted = new byte[0];
                break;
            }
            case AES_KW_128: 
            case AES_KW_192: 
            case AES_KW_256: {
                if (rgbKey == null) {
                    if (this.privateKey.get(KeyKeys.KeyType.AsCBOR()) != KeyKeys.KeyType_Octet) {
                        throw new CoseException("Key and algorithm do not agree");
                    }
                    rgbKey = this.privateKey.get(KeyKeys.Octet_K.AsCBOR()).GetByteString();
                }
                this.rgbEncrypted = this.AES_KeyWrap_Encrypt(alg, rgbKey);
                break;
            }
            case ECDH_ES_HKDF_256: 
            case ECDH_SS_HKDF_256: 
            case ECDH_ES_HKDF_512: 
            case ECDH_SS_HKDF_512: {
                this.rgbEncrypted = new byte[0];
                break;
            }
            case ECDH_ES_HKDF_256_AES_KW_128: {
                if (this.privateKey.get(KeyKeys.KeyType.AsCBOR()) != KeyKeys.KeyType_EC2) {
                    throw new CoseException("Key and algorithm do not agree");
                }
                this.ECDH_GenerateEphemeral();
                rgbKey = this.ECDH_GenerateSecret(this.privateKey);
                rgbKey = this.HKDF(rgbKey, 128, AlgorithmID.AES_KW_128, (Digest)new SHA256Digest());
                this.rgbEncrypted = this.AES_KeyWrap_Encrypt(AlgorithmID.AES_KW_128, rgbKey);
                break;
            }
            case ECDH_SS_HKDF_256_AES_KW_128: {
                byte[] rgbAPU;
                if (this.privateKey.get(KeyKeys.KeyType.AsCBOR()) != KeyKeys.KeyType_EC2) {
                    throw new CoseException("Key and algorithm do not agree");
                }
                if (this.findAttribute(HeaderKeys.HKDF_Context_PartyU_nonce.AsCBOR()) == null) {
                    rgbAPU = new byte[32];
                    random = new SecureRandom();
                    random.nextBytes(rgbAPU);
                    this.addAttribute(HeaderKeys.HKDF_Context_PartyU_nonce.AsCBOR(), CBORObject.FromObject((byte[])rgbAPU), 2);
                }
                rgbKey = this.ECDH_GenerateSecret(this.privateKey);
                rgbKey = this.HKDF(rgbKey, 128, AlgorithmID.AES_KW_128, (Digest)new SHA256Digest());
                this.rgbEncrypted = this.AES_KeyWrap_Encrypt(AlgorithmID.AES_KW_128, rgbKey);
                break;
            }
            case ECDH_ES_HKDF_256_AES_KW_192: {
                if (this.privateKey.get(KeyKeys.KeyType.AsCBOR()) != KeyKeys.KeyType_EC2) {
                    throw new CoseException("Key and algorithm do not agree");
                }
                this.ECDH_GenerateEphemeral();
                rgbKey = this.ECDH_GenerateSecret(this.privateKey);
                rgbKey = this.HKDF(rgbKey, 192, AlgorithmID.AES_KW_192, (Digest)new SHA256Digest());
                this.rgbEncrypted = this.AES_KeyWrap_Encrypt(AlgorithmID.AES_KW_192, rgbKey);
                break;
            }
            case ECDH_SS_HKDF_256_AES_KW_192: {
                byte[] rgbAPU;
                if (this.privateKey.get(KeyKeys.KeyType.AsCBOR()) != KeyKeys.KeyType_EC2) {
                    throw new CoseException("Key and algorithm do not agree");
                }
                if (this.findAttribute(HeaderKeys.HKDF_Context_PartyU_nonce.AsCBOR()) == null) {
                    rgbAPU = new byte[32];
                    random = new SecureRandom();
                    random.nextBytes(rgbAPU);
                    this.addAttribute(HeaderKeys.HKDF_Context_PartyU_nonce.AsCBOR(), CBORObject.FromObject((byte[])rgbAPU), 2);
                }
                rgbKey = this.ECDH_GenerateSecret(this.privateKey);
                rgbKey = this.HKDF(rgbKey, 192, AlgorithmID.AES_KW_192, (Digest)new SHA256Digest());
                this.rgbEncrypted = this.AES_KeyWrap_Encrypt(AlgorithmID.AES_KW_192, rgbKey);
                break;
            }
            case ECDH_ES_HKDF_256_AES_KW_256: {
                if (this.privateKey.get(KeyKeys.KeyType.AsCBOR()) != KeyKeys.KeyType_EC2) {
                    throw new CoseException("Key and algorithm do not agree");
                }
                this.ECDH_GenerateEphemeral();
                rgbKey = this.ECDH_GenerateSecret(this.privateKey);
                rgbKey = this.HKDF(rgbKey, 256, AlgorithmID.AES_KW_256, (Digest)new SHA256Digest());
                this.rgbEncrypted = this.AES_KeyWrap_Encrypt(AlgorithmID.AES_KW_256, rgbKey);
                break;
            }
            case ECDH_SS_HKDF_256_AES_KW_256: {
                byte[] rgbAPU;
                if (this.privateKey.get(KeyKeys.KeyType.AsCBOR()) != KeyKeys.KeyType_EC2) {
                    throw new CoseException("Key and algorithm do not agree");
                }
                if (this.findAttribute(HeaderKeys.HKDF_Context_PartyU_nonce.AsCBOR()) == null) {
                    rgbAPU = new byte[32];
                    random = new SecureRandom();
                    random.nextBytes(rgbAPU);
                    this.addAttribute(HeaderKeys.HKDF_Context_PartyU_nonce.AsCBOR(), CBORObject.FromObject((byte[])rgbAPU), 2);
                }
                rgbKey = this.ECDH_GenerateSecret(this.privateKey);
                rgbKey = this.HKDF(rgbKey, 256, AlgorithmID.AES_KW_256, (Digest)new SHA256Digest());
                this.rgbEncrypted = this.AES_KeyWrap_Encrypt(AlgorithmID.AES_KW_256, rgbKey);
                break;
            }
            default: {
                throw new CoseException("Unsupported Recipient Algorithm");
            }
        }
        if (this.recipientList != null) {
            for (Recipient r : this.recipientList) {
                r.SetContent(rgbKey);
                r.encrypt();
            }
        }
    }

    public void addRecipient(Recipient recipient) {
        if (this.recipientList == null) {
            this.recipientList = new ArrayList<Recipient>();
        }
        this.recipientList.add(recipient);
    }

    public List<Recipient> getRecipientList() {
        return this.recipientList;
    }

    public Recipient getRecipient(int iRecipient) {
        return this.recipientList.get(iRecipient);
    }

    public int getRecipientCount() {
        return this.recipientList.size();
    }

    public int getRecipientType() throws CoseException {
        AlgorithmID alg = AlgorithmID.FromCBOR(this.findAttribute(HeaderKeys.Algorithm));
        switch (alg) {
            case Direct: 
            case HKDF_HMAC_SHA_256: 
            case HKDF_HMAC_SHA_512: 
            case ECDH_ES_HKDF_256: 
            case ECDH_SS_HKDF_256: 
            case ECDH_ES_HKDF_512: 
            case ECDH_SS_HKDF_512: {
                return 1;
            }
        }
        return 9;
    }

    public byte[] getKey(AlgorithmID algCEK) throws CoseException, Exception {
        if (this.privateKey == null) {
            throw new CoseException("Private key not set for recipient");
        }
        AlgorithmID alg = AlgorithmID.FromCBOR(this.findAttribute(HeaderKeys.Algorithm));
        switch (alg) {
            case Direct: {
                if (this.privateKey.get(KeyKeys.KeyType.AsCBOR()) != KeyKeys.KeyType_Octet) {
                    throw new CoseException("Key and algorithm do not agree");
                }
                return this.privateKey.get(KeyKeys.Octet_K.AsCBOR()).GetByteString();
            }
            case AES_KW_128: 
            case AES_KW_192: 
            case AES_KW_256: {
                throw new Exception("Internal Error");
            }
            case ECDH_ES_HKDF_256: {
                if (this.privateKey.get(KeyKeys.KeyType.AsCBOR()) != KeyKeys.KeyType_EC2) {
                    throw new CoseException("Key and algorithm do not agree");
                }
                this.ECDH_GenerateEphemeral();
                byte[] rgbSecret = this.ECDH_GenerateSecret(this.privateKey);
                return this.HKDF(rgbSecret, algCEK.getKeySize(), algCEK, (Digest)new SHA256Digest());
            }
            case ECDH_ES_HKDF_512: {
                if (this.privateKey.get(KeyKeys.KeyType.AsCBOR()) != KeyKeys.KeyType_EC2) {
                    throw new CoseException("Key and algorithm do not agree");
                }
                this.ECDH_GenerateEphemeral();
                byte[] rgbSecret = this.ECDH_GenerateSecret(this.privateKey);
                return this.HKDF(rgbSecret, algCEK.getKeySize(), algCEK, (Digest)new SHA512Digest());
            }
            case ECDH_SS_HKDF_256: {
                if (this.privateKey.get(KeyKeys.KeyType.AsCBOR()) != KeyKeys.KeyType_EC2) {
                    throw new CoseException("Key and algorithm do not agree");
                }
                if (this.findAttribute(HeaderKeys.HKDF_Context_PartyU_nonce.AsCBOR()) == null) {
                    byte[] rgbAPU = new byte[32];
                    SecureRandom random = new SecureRandom();
                    random.nextBytes(rgbAPU);
                    this.addAttribute(HeaderKeys.HKDF_Context_PartyU_nonce.AsCBOR(), CBORObject.FromObject((byte[])rgbAPU), 2);
                }
                byte[] rgbSecret = this.ECDH_GenerateSecret(this.privateKey);
                return this.HKDF(rgbSecret, algCEK.getKeySize(), algCEK, (Digest)new SHA256Digest());
            }
            case ECDH_SS_HKDF_512: {
                if (this.privateKey.get(KeyKeys.KeyType.AsCBOR()) != KeyKeys.KeyType_EC2) {
                    throw new CoseException("Key and algorithm do not agree");
                }
                if (this.findAttribute(HeaderKeys.HKDF_Context_PartyU_nonce.AsCBOR()) == null) {
                    byte[] rgbAPU = new byte[64];
                    SecureRandom random = new SecureRandom();
                    random.nextBytes(rgbAPU);
                    this.addAttribute(HeaderKeys.HKDF_Context_PartyU_nonce.AsCBOR(), CBORObject.FromObject((byte[])rgbAPU), 2);
                }
                byte[] rgbSecret = this.ECDH_GenerateSecret(this.privateKey);
                return this.HKDF(rgbSecret, algCEK.getKeySize(), algCEK, (Digest)new SHA512Digest());
            }
            case HKDF_HMAC_SHA_256: {
                if (this.privateKey.get(KeyKeys.KeyType.AsCBOR()) != KeyKeys.KeyType_Octet) {
                    throw new CoseException("Needs to be an octet key");
                }
                return this.HKDF(this.privateKey.get(KeyKeys.Octet_K.AsCBOR()).GetByteString(), algCEK.getKeySize(), algCEK, (Digest)new SHA256Digest());
            }
            case HKDF_HMAC_SHA_512: {
                if (this.privateKey.get(KeyKeys.KeyType.AsCBOR()) != KeyKeys.KeyType_Octet) {
                    throw new CoseException("Needs to be an octet key");
                }
                return this.HKDF(this.privateKey.get(KeyKeys.Octet_K.AsCBOR()).GetByteString(), algCEK.getKeySize(), algCEK, (Digest)new SHA512Digest());
            }
        }
        throw new CoseException("Recipient Algorithm not supported");
    }

    @Deprecated
    public void SetKey(CBORObject key) throws CoseException {
        this.privateKey = new OneKey(key);
    }

    public void SetKey(OneKey key) {
        this.privateKey = key;
    }

    @Deprecated
    public void SetSenderKey(CBORObject key) throws CoseException {
        this.senderKey = new OneKey(key);
    }

    public void SetSenderKey(OneKey key) {
        this.senderKey = key;
    }

    private byte[] AES_KeyWrap_Encrypt(AlgorithmID alg, byte[] rgbKey) throws CoseException {
        if (rgbKey.length != alg.getKeySize() / 8) {
            throw new CoseException("Key is not the correct size");
        }
        AESWrapEngine foo = new AESWrapEngine();
        KeyParameter parameters = new KeyParameter(rgbKey);
        foo.init(true, (CipherParameters)parameters);
        return foo.wrap(this.rgbContent, 0, this.rgbContent.length);
    }

    private byte[] AES_KeyWrap_Decrypt(AlgorithmID alg, byte[] rgbKey) throws CoseException, InvalidCipherTextException {
        if (rgbKey.length != alg.getKeySize() / 8) {
            throw new CoseException("Key is not the correct size");
        }
        AESWrapEngine foo = new AESWrapEngine();
        KeyParameter parameters = new KeyParameter(rgbKey);
        foo.init(false, (CipherParameters)parameters);
        return foo.unwrap(this.rgbEncrypted, 0, this.rgbEncrypted.length);
    }

    private void ECDH_GenerateEphemeral() throws CoseException {
        X9ECParameters p = this.privateKey.GetCurve();
        ECDomainParameters parameters = new ECDomainParameters(p.getCurve(), p.getG(), p.getN(), p.getH());
        ECKeyPairGenerator pGen = new ECKeyPairGenerator();
        ECKeyGenerationParameters genParam = new ECKeyGenerationParameters(parameters, null);
        pGen.init((KeyGenerationParameters)genParam);
        AsymmetricCipherKeyPair p1 = pGen.generateKeyPair();
        CBORObject epk = CBORObject.NewMap();
        epk.Add((Object)KeyKeys.KeyType.AsCBOR(), (Object)KeyKeys.KeyType_EC2);
        epk.Add((Object)KeyKeys.EC2_Curve.AsCBOR(), (Object)this.privateKey.get(KeyKeys.EC2_Curve.AsCBOR()));
        ECPublicKeyParameters priv = (ECPublicKeyParameters)p1.getPublic();
        byte[] rgbEncoded = priv.getQ().normalize().getEncoded(true);
        byte[] X = new byte[rgbEncoded.length - 1];
        System.arraycopy(rgbEncoded, 1, X, 0, X.length);
        epk.Add((Object)KeyKeys.EC2_X.AsCBOR(), (Object)CBORObject.FromObject((byte[])X));
        epk.Add((Object)KeyKeys.EC2_Y.AsCBOR(), (Object)CBORObject.FromObject(((rgbEncoded[0] & 1) == 1 ? 1 : 0) != 0));
        this.addAttribute(HeaderKeys.ECDH_EPK, epk, 2);
        OneKey secretKey = new OneKey();
        secretKey.add(KeyKeys.KeyType, KeyKeys.KeyType_EC2);
        secretKey.add(KeyKeys.EC2_Curve, this.privateKey.get(KeyKeys.EC2_Curve.AsCBOR()));
        secretKey.add(KeyKeys.EC2_X, CBORObject.FromObject((byte[])X));
        secretKey.add(KeyKeys.EC2_Y, CBORObject.FromObject(((rgbEncoded[0] & 1) == 1 ? 1 : 0) != 0));
        ECPrivateKeyParameters priv1 = (ECPrivateKeyParameters)p1.getPrivate();
        secretKey.add(KeyKeys.EC2_D, CBORObject.FromObject((byte[])BigIntegers.asUnsignedByteArray((BigInteger)priv1.getD())));
        this.senderKey = secretKey;
    }

    private byte[] ECDH_GenerateSecret(OneKey key) throws CoseException {
        ECPoint pubPoint;
        OneKey epk;
        if (this.senderKey != null) {
            epk = key;
            key = this.senderKey;
        } else {
            CBORObject cn = this.findAttribute(HeaderKeys.ECDH_SPK);
            if (cn == null) {
                cn = this.findAttribute(HeaderKeys.ECDH_EPK);
            }
            if (cn == null) {
                throw new CoseException("No second party EC key");
            }
            epk = new OneKey(cn);
        }
        if (key.get(KeyKeys.KeyType.AsCBOR()) != KeyKeys.KeyType_EC2) {
            throw new CoseException("Not an EC2 Key");
        }
        if (epk.get(KeyKeys.KeyType.AsCBOR()) != KeyKeys.KeyType_EC2) {
            throw new CoseException("Not an EC2 Key");
        }
        if (epk.get(KeyKeys.EC2_Curve.AsCBOR()) != key.get(KeyKeys.EC2_Curve.AsCBOR())) {
            throw new CoseException("Curves are not the same");
        }
        X9ECParameters p = epk.GetCurve();
        ECDomainParameters parameters = new ECDomainParameters(p.getCurve(), p.getG(), p.getN(), p.getH());
        CBORObject y = epk.get(KeyKeys.EC2_Y.AsCBOR());
        byte[] x = epk.get(KeyKeys.EC2_X.AsCBOR()).GetByteString();
        if (y.getType() == CBORType.Boolean) {
            byte[] X = epk.get(KeyKeys.EC2_X.AsCBOR()).GetByteString();
            byte[] rgb = new byte[X.length + 1];
            System.arraycopy(X, 0, rgb, 1, X.length);
            rgb[0] = (byte)(2 + (y.AsBoolean() ? 1 : 0));
            pubPoint = p.getCurve().decodePoint(rgb);
        } else {
            pubPoint = p.getCurve().createPoint(new BigInteger(1, x), new BigInteger(1, y.GetByteString()));
        }
        ECPublicKeyParameters pub = new ECPublicKeyParameters(pubPoint, parameters);
        ECPrivateKeyParameters priv = new ECPrivateKeyParameters(new BigInteger(1, key.get(KeyKeys.EC2_D.AsCBOR()).GetByteString()), parameters);
        ECDHBasicAgreement e1 = new ECDHBasicAgreement();
        e1.init((CipherParameters)priv);
        BigInteger k1 = e1.calculateAgreement((CipherParameters)pub);
        return BigIntegers.asUnsignedByteArray((int)((p.getCurve().getFieldSize() + 7) / 8), (BigInteger)k1);
    }

    private byte[] HKDF(byte[] secret, int cbitKey, AlgorithmID algorithmID, Digest digest) {
        byte[] rgbContext = this.GetKDFInput(cbitKey, algorithmID);
        CBORObject obj = this.findAttribute(HeaderKeys.HKDF_Salt.AsCBOR());
        HMac mac = new HMac(digest);
        int hashLength = digest.getDigestSize();
        int c = ((cbitKey + 7) / 8 + hashLength - 1) / hashLength;
        byte[] K = new byte[digest.getDigestSize()];
        if (obj != null) {
            K = obj.GetByteString();
        }
        KeyParameter key = new KeyParameter(K);
        mac.init((CipherParameters)key);
        mac.update(secret, 0, secret.length);
        byte[] rgbExtract = new byte[hashLength];
        mac.doFinal(rgbExtract, 0);
        byte[] rgbOut = new byte[cbitKey / 8];
        byte[] rgbT = new byte[hashLength * c];
        mac = new HMac(digest);
        key = new KeyParameter(rgbExtract);
        mac.init((CipherParameters)key);
        byte[] rgbLast = new byte[]{};
        byte[] rgbHash2 = new byte[hashLength];
        for (int i = 0; i < c; ++i) {
            mac.reset();
            mac.update(rgbLast, 0, rgbLast.length);
            mac.update(rgbContext, 0, rgbContext.length);
            mac.update((byte)(i + 1));
            rgbLast = rgbHash2;
            mac.doFinal(rgbLast, 0);
            System.arraycopy(rgbLast, 0, rgbT, i * hashLength, hashLength);
        }
        System.arraycopy(rgbT, 0, rgbOut, 0, cbitKey / 8);
        return rgbOut;
    }

    private byte[] GetKDFInput(int cbitKey, AlgorithmID algorithmID) {
        CBORObject contextArray = CBORObject.NewArray();
        contextArray.Add(algorithmID.AsCBOR());
        CBORObject info = CBORObject.NewArray();
        contextArray.Add(info);
        CBORObject obj = this.findAttribute(HeaderKeys.HKDF_Context_PartyU_ID.AsCBOR());
        if (obj != null) {
            info.Add(obj);
        } else {
            info.Add(null);
        }
        obj = this.findAttribute(HeaderKeys.HKDF_Context_PartyU_nonce.AsCBOR());
        if (obj != null) {
            info.Add(obj);
        } else {
            info.Add(null);
        }
        obj = this.findAttribute(HeaderKeys.HKDF_Context_PartyU_Other.AsCBOR());
        if (obj != null) {
            info.Add(obj);
        } else {
            info.Add(null);
        }
        info = CBORObject.NewArray();
        contextArray.Add(info);
        obj = this.findAttribute(HeaderKeys.HKDF_Context_PartyV_ID.AsCBOR());
        if (obj != null) {
            info.Add(obj);
        } else {
            info.Add(null);
        }
        obj = this.findAttribute(HeaderKeys.HKDF_Context_PartyV_nonce.AsCBOR());
        if (obj != null) {
            info.Add(obj);
        } else {
            info.Add(null);
        }
        obj = this.findAttribute(HeaderKeys.HKDF_Context_PartyV_Other.AsCBOR());
        if (obj != null) {
            info.Add(obj);
        } else {
            info.Add(null);
        }
        info = CBORObject.NewArray();
        contextArray.Add(info);
        info.Add(CBORObject.FromObject((int)cbitKey));
        if (this.objProtected.size() == 0) {
            info.Add((Object)new byte[0]);
        } else {
            info.Add((Object)this.objProtected.EncodeToBytes());
        }
        obj = this.findAttribute(HeaderKeys.HKDF_SuppPub_Other.AsCBOR());
        if (obj != null) {
            info.Add(obj);
        }
        if ((obj = this.findAttribute(HeaderKeys.HKDF_SuppPriv_Other.AsCBOR())) != null) {
            contextArray.Add(obj);
        }
        return contextArray.EncodeToBytes();
    }
}

