/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.icatch.imp;

import com.atomikos.icatch.HeurCommitException;
import com.atomikos.icatch.HeurHazardException;
import com.atomikos.icatch.HeurMixedException;
import com.atomikos.icatch.HeurRollbackException;
import com.atomikos.icatch.Participant;
import com.atomikos.icatch.RollbackException;
import com.atomikos.icatch.SysException;
import com.atomikos.icatch.imp.CommitMessage;
import com.atomikos.icatch.imp.CoordinatorStateHandler;
import com.atomikos.icatch.imp.Reply;
import com.atomikos.icatch.imp.RollbackMessage;
import com.atomikos.icatch.imp.TerminatedStateHandler;
import com.atomikos.icatch.imp.TerminationResult;
import com.atomikos.recovery.TxState;
import com.atomikos.thread.InterruptedExceptionHelper;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.Stack;

class HeurMixedStateHandler
extends CoordinatorStateHandler {
    private Set<Participant> hazards_;

    HeurMixedStateHandler(CoordinatorStateHandler previous, Set<Participant> hazards) {
        super(previous);
        this.hazards_ = new HashSet<Participant>(hazards);
    }

    @Override
    protected TxState getState() {
        return TxState.HEUR_MIXED;
    }

    @Override
    protected void onTimeout() {
        Boolean commitDecided = this.getCommitted();
        this.addAllForReplay(this.hazards_);
        Stack<Participant> replayStack = this.getReplayStack();
        boolean replay = false;
        if (!replayStack.empty() && commitDecided != null) {
            boolean committed = commitDecided;
            replay = true;
            int count = replayStack.size();
            TerminationResult result = new TerminationResult(count);
            while (!replayStack.empty()) {
                Participant part = replayStack.pop();
                if (committed) {
                    CommitMessage cm = new CommitMessage(part, result, false);
                    this.getPropagator().submitPropagationMessage(cm);
                    continue;
                }
                RollbackMessage rm = new RollbackMessage(part, result, true);
                this.getPropagator().submitPropagationMessage(rm);
            }
            try {
                result.waitForReplies();
                Stack<Reply> replies = result.getReplies();
                Enumeration enumm = replies.elements();
                while (enumm.hasMoreElements()) {
                    Reply reply = (Reply)enumm.nextElement();
                    if (reply.hasFailed()) continue;
                    this.hazards_.remove(reply.getParticipant());
                }
                if (this.hazards_.isEmpty()) {
                    TerminatedStateHandler termStateHandler = new TerminatedStateHandler(this);
                    this.getCoordinator().setStateHandler(termStateHandler);
                } else if (replay) {
                    this.getCoordinator().setStateHandler(this);
                }
            }
            catch (InterruptedException inter) {
                InterruptedExceptionHelper.handleInterruptedException((InterruptedException)inter);
            }
        }
    }

    @Override
    protected void setGlobalSiblingCount(int count) {
    }

    @Override
    protected int prepare() throws RollbackException, IllegalStateException, HeurHazardException, HeurMixedException, SysException {
        throw new HeurHazardException();
    }

    @Override
    protected void commit(boolean onePhase) throws HeurRollbackException, HeurMixedException, HeurHazardException, IllegalStateException, RollbackException, SysException {
        throw new HeurMixedException();
    }

    @Override
    protected void rollback() throws HeurCommitException, HeurMixedException, SysException, HeurHazardException, IllegalStateException {
        throw new HeurMixedException();
    }
}

