/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.icatch.admin.imp;

import com.atomikos.icatch.admin.LogAdministrator;
import com.atomikos.icatch.admin.LogControl;
import com.atomikos.icatch.admin.imp.AdminTool;
import com.atomikos.icatch.config.UserTransactionService;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;

public class LocalLogAdministrator
implements ActionListener,
LogAdministrator {
    private JFrame frame_;
    private UserTransactionService service_;
    private JMenuItem inspect_;
    private JMenuItem exit_;
    private LogControl control_;
    private ResourceBundle messages_;

    public LocalLogAdministrator() {
        this("Atomikos LogAdministrator", true);
    }

    public LocalLogAdministrator(String title, boolean standalone) {
        this.frame_ = new JFrame(title);
        this.frame_.setDefaultCloseOperation(0);
        this.messages_ = ResourceBundle.getBundle("com.atomikos.icatch.admin.imp.AdminToolResourceBundle");
        JMenuBar mb = new JMenuBar();
        JMenu m = new JMenu(this.messages_.getString("mainMenuName"));
        m.setMnemonic(77);
        this.inspect_ = new JMenuItem(this.messages_.getString("showActiveTransactionsMenuItemName") + "...", this.messages_.getString("showActiveTransactionsMenuItemName").charAt(0));
        this.inspect_.addActionListener(this);
        this.inspect_.setEnabled(false);
        m.add(this.inspect_);
        if (standalone) {
            this.exit_ = new JMenuItem(this.messages_.getString("exitMenuItemName"), this.messages_.getString("exitMenuItemName").charAt(0));
            this.exit_.addActionListener(this);
            m.add(this.exit_);
        }
        mb.add(m);
        this.frame_.setJMenuBar(mb);
        Dimension defaultSize = new Dimension(486, 380);
        this.frame_.setSize(defaultSize);
        this.frame_.setVisible(true);
    }

    public void registerLogControl(LogControl control) {
        if (this.control_ != null) {
            throw new IllegalStateException("Second control registered");
        }
        this.control_ = control;
        this.inspect_.setEnabled(true);
    }

    public void deregisterLogControl(LogControl control) {
        if (this.control_ == control) {
            this.control_ = null;
        }
        this.inspect_.setEnabled(false);
        this.frame_.dispose();
    }

    public void init(UserTransactionService service) {
        this.service_ = service;
        this.frame_.show();
    }

    public JFrame getJFrame() {
        return this.frame_;
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        try {
            if (ev.getSource() == this.inspect_) {
                if (this.control_ != null) {
                    try {
                        AdminTool tool = new AdminTool(this.control_);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                } else {
                    System.err.println("LogAdministrator: no control registered?");
                }
            } else if (ev.getSource() == this.exit_) {
                try {
                    if (this.service_ != null) {
                        this.service_.shutdown(true);
                    }
                    System.exit(0);
                }
                catch (IllegalStateException il) {
                    int n = JOptionPane.showConfirmDialog(this.frame_, this.messages_.getString("shutdownMessage"), this.messages_.getString("shutdownTitle"), 0);
                    if (n == 0) {
                        this.service_.shutdown(true);
                        System.exit(0);
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

