/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.icatch.system;

import com.atomikos.datasource.RecoverableResource;
import com.atomikos.diagnostics.CascadedConsole;
import com.atomikos.diagnostics.Console;
import com.atomikos.icatch.CompositeTransactionManager;
import com.atomikos.icatch.ExportingTransactionManager;
import com.atomikos.icatch.ImportingTransactionManager;
import com.atomikos.icatch.RecoveryService;
import com.atomikos.icatch.TSListener;
import com.atomikos.icatch.TransactionService;
import com.atomikos.icatch.admin.LogAdministrator;
import com.atomikos.icatch.admin.LogControl;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;

public final class Configuration {
    public static final String VERSION = "3.2.3";
    private static CompositeTransactionManager ctxmgr_ = null;
    private static ImportingTransactionManager imptxmgr_ = null;
    private static ExportingTransactionManager exptxmgr_ = null;
    private static Hashtable resources_ = new Hashtable();
    private static Console console_;
    private static Vector resourceList_;
    private static Vector logAdministrators_;
    private static LogControl logControl_;
    private static RecoveryService recoveryService_;
    private static TransactionService service_;
    private static Vector tsListenersList_;

    private static void purgeResources() {
        Enumeration enumeration = Configuration.getResources();
        while (enumeration.hasMoreElements()) {
            RecoverableResource recoverableResource = (RecoverableResource)enumeration.nextElement();
            if (!recoverableResource.isClosed()) continue;
            Configuration.removeResource(recoverableResource.getName());
        }
    }

    private Configuration() {
    }

    public static synchronized void installTransactionService(TransactionService transactionService) {
        service_ = transactionService;
        Iterator iterator = tsListenersList_.iterator();
        while (iterator.hasNext() && transactionService != null) {
            TSListener tSListener = (TSListener)iterator.next();
            service_.addTSListener(tSListener);
        }
    }

    public static TransactionService getTransactionService() {
        return service_;
    }

    public static synchronized void addTSListener(TSListener tSListener) {
        if (service_ != null) {
            service_.addTSListener(tSListener);
        }
        tsListenersList_.add(tSListener);
    }

    public static synchronized void removeTSListener(TSListener tSListener) {
        if (service_ != null) {
            service_.removeTSListener(tSListener);
        }
        tsListenersList_.remove(tSListener);
    }

    public static synchronized void installCompositeTransactionManager(CompositeTransactionManager compositeTransactionManager) {
        ctxmgr_ = compositeTransactionManager;
    }

    public static synchronized void installRecoveryService(RecoveryService recoveryService) {
        recoveryService_ = recoveryService;
        if (recoveryService != null) {
            Enumeration enumeration = Configuration.getResources();
            while (enumeration.hasMoreElements()) {
                RecoverableResource recoverableResource = (RecoverableResource)enumeration.nextElement();
                recoverableResource.setRecoveryService(recoveryService);
            }
        }
    }

    public static synchronized void installLogControl(LogControl logControl) {
        logControl_ = logControl;
        if (logControl_ != null) {
            Enumeration enumeration = Configuration.getLogAdministrators();
            while (enumeration.hasMoreElements()) {
                LogAdministrator logAdministrator = (LogAdministrator)enumeration.nextElement();
                logAdministrator.registerLogControl(logControl);
            }
        }
    }

    public static synchronized void installImportingTransactionManager(ImportingTransactionManager importingTransactionManager) {
        imptxmgr_ = importingTransactionManager;
    }

    public static synchronized void installExportingTransactionManager(ExportingTransactionManager exportingTransactionManager) {
        exptxmgr_ = exportingTransactionManager;
    }

    public static CompositeTransactionManager getCompositeTransactionManager() {
        return ctxmgr_;
    }

    public static ImportingTransactionManager getImportingTransactionManager() {
        return imptxmgr_;
    }

    public static ExportingTransactionManager getExportingTransactionManager() {
        return exptxmgr_;
    }

    public static synchronized void addResource(RecoverableResource recoverableResource) throws IllegalStateException {
        Configuration.purgeResources();
        int n = resources_.size();
        if (n > 100) {
            Configuration.logWarning(n + " RESOURCES IN CONFIGURATION -- " + "SOME XARESOURCE IMPLEMENTATIONS MAY NOT CORRECTLY IMPLEMENT isSameRM()!");
            Configuration.logWarning("TO SAVE MEMORY, USE EXPLICIT RESOURCE REGISTRATION MODE.");
        }
        if (resources_.containsKey(recoverableResource.getName())) {
            throw new IllegalStateException("Attempt to register second resource with name " + recoverableResource.getName());
        }
        Configuration.logDebug("Configuration: adding resource " + recoverableResource.getName());
        resources_.put(recoverableResource.getName(), recoverableResource);
        resourceList_.add(recoverableResource);
        recoverableResource.setRecoveryService(recoveryService_);
        Configuration.logDebug("Configuration: added resource " + recoverableResource.getName());
    }

    public static synchronized void addLogAdministrator(LogAdministrator logAdministrator) {
        logAdministrators_.add(logAdministrator);
        if (logControl_ != null) {
            logAdministrator.registerLogControl(logControl_);
        }
    }

    public static void removeLogAdministrator(LogAdministrator logAdministrator) {
        logAdministrators_.remove(logAdministrator);
        if (logControl_ != null) {
            logAdministrator.deregisterLogControl(logControl_);
        }
    }

    public static Enumeration getLogAdministrators() {
        Vector vector = (Vector)logAdministrators_.clone();
        return vector.elements();
    }

    public static RecoverableResource removeResource(String string) {
        RecoverableResource recoverableResource = (RecoverableResource)resources_.remove(string);
        resourceList_.remove(recoverableResource);
        Configuration.logDebug("Configuration: removed resource " + string);
        return recoverableResource;
    }

    public static RecoverableResource getResource(String string) {
        RecoverableResource recoverableResource = (RecoverableResource)resources_.get(string);
        return recoverableResource;
    }

    public static Enumeration getResources() {
        Vector vector = (Vector)resourceList_.clone();
        return vector.elements();
    }

    public static synchronized void addConsole(Console console) {
        if (console_ == null) {
            console_ = console;
        } else {
            CascadedConsole cascadedConsole = new CascadedConsole(console_, console);
            console_ = cascadedConsole;
        }
    }

    public static Console getConsole() {
        return console_;
    }

    public static void removeConsoles() {
        console_ = null;
    }

    public static void logWarning(String string) {
        Configuration.log(string, 1);
    }

    public static void logWarning(String string, Exception exception) {
        Configuration.log(string, exception, 1);
    }

    public static void logInfo(String string) {
        Configuration.log(string, 2);
    }

    public static void logInfo(String string, Exception exception) {
        Configuration.log(string, exception, 2);
    }

    public static void logDebug(String string) {
        Configuration.log(string, 3);
    }

    public static void logDebug(String string, Exception exception) {
        Configuration.log(string, exception, 3);
    }

    private static void log(String string, int n) {
        try {
            Console console = Configuration.getConsole();
            if (console != null) {
                console.println(string, n);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void log(String string, Throwable throwable, int n) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        throwable.printStackTrace(printWriter);
        printWriter.close();
        String string2 = stringWriter.toString();
        String string3 = string2.substring(0, string2.length() - 1);
        Configuration.log(string + "\n" + string3, n);
    }

    static {
        resourceList_ = new Vector();
        logAdministrators_ = new Vector();
        tsListenersList_ = new Vector();
    }
}

