/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.icatch.imp;

import com.atomikos.icatch.HeurCommitException;
import com.atomikos.icatch.HeurHazardException;
import com.atomikos.icatch.HeurMixedException;
import com.atomikos.icatch.HeurRollbackException;
import com.atomikos.icatch.HeuristicMessage;
import com.atomikos.icatch.RollbackException;
import com.atomikos.icatch.SysException;
import com.atomikos.icatch.TxState;
import com.atomikos.icatch.admin.AdminTransaction;
import com.atomikos.icatch.imp.CoordinatorImp;
import java.util.Stack;

class AdminTransactionImp
implements AdminTransaction {
    private CoordinatorImp coord_;

    static int convertState(Object object) {
        int n = -1;
        if (object.equals(TxState.ACTIVE)) {
            n = -3;
        } else if (object.equals(TxState.PREPARING)) {
            n = -2;
        } else if (object.equals(TxState.IN_DOUBT)) {
            n = 0;
        } else if (object.equals(TxState.HEUR_MIXED)) {
            n = 4;
        } else if (object.equals(TxState.HEUR_HAZARD)) {
            n = 3;
        } else if (object.equals(TxState.HEUR_COMMITTED)) {
            n = 1;
        } else if (object.equals(TxState.HEUR_ABORTED)) {
            n = 2;
        } else if (object.equals(TxState.COMMITTING)) {
            n = 6;
        } else if (object.equals(TxState.ABORTING)) {
            n = 5;
        } else if (object.equals(TxState.TERMINATED)) {
            n = 7;
        }
        return n;
    }

    static Object convertState(int n) {
        TxState txState = null;
        switch (n) {
            case 0: {
                txState = TxState.IN_DOUBT;
                break;
            }
            case 4: {
                txState = TxState.HEUR_MIXED;
                break;
            }
            case 3: {
                txState = TxState.HEUR_HAZARD;
                break;
            }
            case 1: {
                txState = TxState.HEUR_COMMITTED;
                break;
            }
            case 2: {
                txState = TxState.HEUR_ABORTED;
                break;
            }
            case 6: {
                txState = TxState.COMMITTING;
                break;
            }
            case 5: {
                txState = TxState.ABORTING;
                break;
            }
            case 7: {
                txState = TxState.TERMINATED;
                break;
            }
        }
        return txState;
    }

    AdminTransactionImp(CoordinatorImp coordinatorImp) {
        this.coord_ = coordinatorImp;
    }

    public String getTid() {
        return this.coord_.getCoordinatorId();
    }

    public boolean wasCommitted() {
        return this.coord_.isCommitted();
    }

    public int getState() {
        Object object = this.coord_.getState();
        return AdminTransactionImp.convertState(object);
    }

    public HeuristicMessage[] getTags() {
        return this.coord_.getTags();
    }

    public HeuristicMessage[] getHeuristicMessages() {
        return this.coord_.getHeuristicMessages();
    }

    public HeuristicMessage[] getHeuristicMessages(int n) {
        HeuristicMessage[] heuristicMessageArray = null;
        Object object = AdminTransactionImp.convertState(n);
        if (object != null) {
            heuristicMessageArray = this.coord_.getHeuristicMessages(object);
        }
        return heuristicMessageArray;
    }

    public void forceCommit() throws HeurRollbackException, HeurHazardException, HeurMixedException, SysException {
        try {
            this.coord_.commitHeuristically();
        }
        catch (RollbackException rollbackException) {
            Stack<RollbackException> stack = new Stack<RollbackException>();
            stack.push(rollbackException);
            throw new SysException("Error in forced commit: " + rollbackException.getMessage(), stack);
        }
    }

    public void forceRollback() throws HeurCommitException, HeurMixedException, HeurHazardException, SysException {
        this.coord_.rollbackHeuristically();
    }

    public void forceForget() {
        this.coord_.forget();
    }
}

