/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.icatch.config.imp;

import com.atomikos.datasource.RecoverableResource;
import com.atomikos.datasource.ResourceException;
import com.atomikos.icatch.CompositeTransactionManager;
import com.atomikos.icatch.ExportingTransactionManager;
import com.atomikos.icatch.ImportingTransactionManager;
import com.atomikos.icatch.SysException;
import com.atomikos.icatch.TSListener;
import com.atomikos.icatch.admin.LogAdministrator;
import com.atomikos.icatch.config.TSInitInfo;
import com.atomikos.icatch.config.UserTransactionService;
import com.atomikos.icatch.system.Configuration;
import com.atomikos.util.IOHelper;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;

public abstract class AbstractUserTransactionService
implements UserTransactionService {
    private TSInitInfo info_;

    private static void echoProperties(Properties properties) {
        if (properties != null) {
            Enumeration<?> enumeration = properties.propertyNames();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                String string2 = properties.getProperty(string);
                Configuration.logWarning("USING " + string + " = " + string2);
            }
        }
    }

    public static String getTrimmedProperty(String string, Properties properties) {
        String string2 = null;
        string2 = properties.getProperty(string);
        if (string2 != null) {
            string2 = string2.trim();
        }
        return string2;
    }

    protected static String getDefaultName() {
        String string = "tm";
        try {
            string = InetAddress.getLocalHost().getHostAddress() + ".tm";
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        return string;
    }

    protected static String getHostAddress() {
        String string = "localhost";
        try {
            string = InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        return string;
    }

    protected static String findOrCreateFolder(String string) {
        Object object;
        Object object2 = new File(".");
        if (string != null) {
            object = new File(string);
            if (((File)object).exists()) {
                if (((File)object).isDirectory()) {
                    object2 = object;
                } else {
                    String string2 = string + " is not a directory - using default";
                    System.err.println(string2);
                }
            } else {
                String string3 = string + " could not be created - using default";
                try {
                    if (IOHelper.createPathTo((File)object, (boolean)true)) {
                        object2 = object;
                    } else {
                        System.err.println(string3);
                    }
                }
                catch (IOException iOException) {
                    System.err.println(string3);
                }
            }
        }
        if (!((String)(object = ((File)object2).getAbsolutePath())).endsWith(File.separator)) {
            object = (String)object + File.separator;
        }
        return object;
    }

    public void shutdown(boolean bl) throws IllegalStateException {
        Enumeration enumeration;
        boolean bl2 = false;
        Enumeration enumeration2 = Configuration.getResources();
        while (enumeration2.hasMoreElements()) {
            enumeration = (RecoverableResource)enumeration2.nextElement();
            Configuration.removeResource(enumeration.getName());
            try {
                enumeration.close();
            }
            catch (ResourceException resourceException) {
                if (!bl) {
                    String string = "WARNING: error closing resource: " + resourceException.getMessage();
                    System.err.println(string);
                    resourceException.printStackTrace();
                }
                bl2 = true;
            }
        }
        Configuration.removeConsoles();
        enumeration = Configuration.getLogAdministrators();
        while (enumeration.hasMoreElements()) {
            LogAdministrator logAdministrator = (LogAdministrator)enumeration.nextElement();
            Configuration.removeLogAdministrator(logAdministrator);
        }
        Configuration.installCompositeTransactionManager(null);
        Configuration.installExportingTransactionManager(null);
        Configuration.installImportingTransactionManager(null);
        Configuration.installRecoveryService(null);
        Configuration.installTransactionService(null);
        Configuration.installLogControl(null);
        if (bl2 && !bl) {
            throw new RuntimeException("Error(s) during shutdown.");
        }
    }

    public void init(TSInitInfo tSInitInfo) throws SysException {
        this.info_ = tSInitInfo;
        AbstractUserTransactionService.echoProperties(tSInitInfo.getProperties());
        Runtime.getRuntime().addShutdownHook(new ShutdownHook(this));
    }

    public CompositeTransactionManager getCompositeTransactionManager() {
        return Configuration.getCompositeTransactionManager();
    }

    public ImportingTransactionManager getImportingTransactionManager() {
        return Configuration.getImportingTransactionManager();
    }

    public ExportingTransactionManager getExportingTransactionManager() {
        return Configuration.getExportingTransactionManager();
    }

    public void registerResource(RecoverableResource recoverableResource) {
        Configuration.addResource(recoverableResource);
    }

    public void registerLogAdministrator(LogAdministrator logAdministrator) {
        Configuration.addLogAdministrator(logAdministrator);
    }

    public Enumeration getResources() {
        return Configuration.getResources();
    }

    public Enumeration getLogAdministrators() {
        return Configuration.getLogAdministrators();
    }

    public void removeResource(RecoverableResource recoverableResource) {
        if (recoverableResource == null) {
            throw new IllegalArgumentException("Null not allowed");
        }
        Configuration.removeResource(recoverableResource.getName());
    }

    public void removeLogAdministrator(LogAdministrator logAdministrator) {
        if (logAdministrator == null) {
            throw new IllegalArgumentException("Null not allowed");
        }
        Configuration.removeLogAdministrator(logAdministrator);
    }

    public void registerTSListener(TSListener tSListener) {
        if (tSListener == null) {
            throw new IllegalArgumentException("Null not allowed");
        }
        Configuration.addTSListener(tSListener);
    }

    public void removeTSListener(TSListener tSListener) {
        if (tSListener == null) {
            throw new IllegalArgumentException("Null not allowed");
        }
        Configuration.removeTSListener(tSListener);
    }

    public void shutdownForce() {
        this.shutdown(true);
    }

    public void shutdownWait() {
        this.shutdown(false);
    }

    public void setRecoverableResources(List list) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            RecoverableResource recoverableResource = (RecoverableResource)iterator.next();
            this.registerResource(recoverableResource);
        }
    }

    public void setLogAdministrators(List list) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            LogAdministrator logAdministrator = (LogAdministrator)iterator.next();
            this.registerLogAdministrator(logAdministrator);
        }
    }

    public void setTSListeners(List list) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            TSListener tSListener = (TSListener)iterator.next();
            this.registerTSListener(tSListener);
        }
    }

    private static class ShutdownHook
    extends Thread {
        private UserTransactionService uts_;

        private ShutdownHook(UserTransactionService userTransactionService) {
            this.uts_ = userTransactionService;
        }

        public void run() {
            this.uts_.shutdown(true);
        }
    }
}

