/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.spring;

import java.time.Duration;
import java.util.Properties;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.util.StringUtils;

@ConfigurationProperties(prefix="atomikos.properties")
public class AtomikosProperties {
    private String service;
    private Duration maxTimeout;
    private Duration defaultJtaTimeout;
    private Integer maxActives;
    private Boolean enableLogging;
    private String transactionManagerUniqueName;
    private Boolean serialJtaTransactions;
    private Boolean allowSubTransactions;
    private Boolean forceShutdownOnVmExit;
    private Long defaultMaxWaitTimeOnShutdown;
    private String logBaseName;
    private String logBaseDir;
    private Long checkpointInterval;
    private Boolean throwOnHeuristic;
    private final Recovery recovery = new Recovery();

    public void setService(String service) {
        this.service = service;
    }

    public String getService() {
        return this.service;
    }

    public void setMaxTimeout(Duration maxTimeout) {
        this.maxTimeout = maxTimeout;
    }

    public Duration getMaxTimeout() {
        return this.maxTimeout;
    }

    public void setDefaultJtaTimeout(Duration defaultJtaTimeout) {
        this.defaultJtaTimeout = defaultJtaTimeout;
    }

    public Duration getDefaultJtaTimeout() {
        return this.defaultJtaTimeout;
    }

    public void setMaxActives(Integer maxActives) {
        this.maxActives = maxActives;
    }

    public Integer getMaxActives() {
        return this.maxActives;
    }

    public void setEnableLogging(Boolean enableLogging) {
        this.enableLogging = enableLogging;
    }

    public Boolean isEnableLogging() {
        return this.enableLogging;
    }

    public void setTransactionManagerUniqueName(String uniqueName) {
        this.transactionManagerUniqueName = uniqueName;
    }

    public String getTransactionManagerUniqueName() {
        return this.transactionManagerUniqueName;
    }

    public void setSerialJtaTransactions(Boolean serialJtaTransactions) {
        this.serialJtaTransactions = serialJtaTransactions;
    }

    public Boolean isSerialJtaTransactions() {
        return this.serialJtaTransactions;
    }

    public void setAllowSubTransactions(Boolean allowSubTransactions) {
        this.allowSubTransactions = allowSubTransactions;
    }

    public Boolean isAllowSubTransactions() {
        return this.allowSubTransactions;
    }

    public void setForceShutdownOnVmExit(Boolean forceShutdownOnVmExit) {
        this.forceShutdownOnVmExit = forceShutdownOnVmExit;
    }

    public Boolean isForceShutdownOnVmExit() {
        return this.forceShutdownOnVmExit;
    }

    public void setDefaultMaxWaitTimeOnShutdown(Long defaultMaxWaitTimeOnShutdown) {
        this.defaultMaxWaitTimeOnShutdown = defaultMaxWaitTimeOnShutdown;
    }

    public Long getDefaultMaxWaitTimeOnShutdown() {
        return this.defaultMaxWaitTimeOnShutdown;
    }

    public void setLogBaseName(String logBaseName) {
        this.logBaseName = logBaseName;
    }

    public String getLogBaseName() {
        return this.logBaseName;
    }

    public void setLogBaseDir(String logBaseDir) {
        this.logBaseDir = logBaseDir;
    }

    public String getLogBaseDir() {
        return this.logBaseDir;
    }

    public void setCheckpointInterval(Long checkpointInterval) {
        this.checkpointInterval = checkpointInterval;
    }

    public Long getCheckpointInterval() {
        return this.checkpointInterval;
    }

    public Recovery getRecovery() {
        return this.recovery;
    }

    public void setThrowOnHeuristic(Boolean throwOnHeuristic) {
        this.throwOnHeuristic = throwOnHeuristic;
    }

    public Boolean isThrowOnHeuristic() {
        return this.throwOnHeuristic;
    }

    public Properties asProperties() {
        Properties properties = new Properties();
        this.set(properties, "service", this.getService());
        this.set(properties, "max_timeout", this.getMaxTimeout());
        this.set(properties, "default_jta_timeout", this.getDefaultJtaTimeout());
        this.set(properties, "max_actives", this.getMaxActives());
        this.set(properties, "enable_logging", this.isEnableLogging());
        this.set(properties, "tm_unique_name", this.getTransactionManagerUniqueName());
        this.set(properties, "serial_jta_transactions", this.isSerialJtaTransactions());
        this.set(properties, "allow_subtransactions", this.isAllowSubTransactions());
        this.set(properties, "force_shutdown_on_vm_exit", this.isForceShutdownOnVmExit());
        this.set(properties, "default_max_wait_time_on_shutdown", this.getDefaultMaxWaitTimeOnShutdown());
        this.set(properties, "log_base_name", this.getLogBaseName());
        this.set(properties, "log_base_dir", this.getOrDeduceLogBaseDir());
        this.set(properties, "checkpoint_interval", this.getCheckpointInterval());
        this.set(properties, "forget_orphaned_log_entries_delay", this.recovery.getForgetOrphanedLogEntriesDelay());
        this.set(properties, "recovery_delay", this.recovery.getDelay());
        this.set(properties, "oltp_max_retries", this.recovery.getMaxRetries());
        this.set(properties, "oltp_retry_interval", this.recovery.getRetryInterval());
        this.set(properties, "throw_on_heuristic", this.isThrowOnHeuristic());
        return properties;
    }

    private String getOrDeduceLogBaseDir() {
        if (StringUtils.hasText((String)this.logBaseDir)) {
            return this.logBaseDir;
        }
        return null;
    }

    private void set(Properties properties, String key, Object value) {
        String id = "com.atomikos.icatch." + key;
        if (value != null && !properties.containsKey(id)) {
            properties.setProperty(id, this.asString(value));
        }
    }

    private String asString(Object value) {
        if (value instanceof Duration) {
            return String.valueOf(((Duration)value).toMillis());
        }
        return value.toString();
    }

    public static class Recovery {
        private Duration forgetOrphanedLogEntriesDelay;
        private Duration delay;
        private Integer maxRetries;
        private Duration retryInterval;

        public Duration getForgetOrphanedLogEntriesDelay() {
            return this.forgetOrphanedLogEntriesDelay;
        }

        public void setForgetOrphanedLogEntriesDelay(Duration forgetOrphanedLogEntriesDelay) {
            this.forgetOrphanedLogEntriesDelay = forgetOrphanedLogEntriesDelay;
        }

        public Duration getDelay() {
            return this.delay;
        }

        public void setDelay(Duration delay) {
            this.delay = delay;
        }

        public Integer getMaxRetries() {
            return this.maxRetries;
        }

        public void setMaxRetries(Integer maxRetries) {
            this.maxRetries = maxRetries;
        }

        public Duration getRetryInterval() {
            return this.retryInterval;
        }

        public void setRetryInterval(Duration retryInterval) {
            this.retryInterval = retryInterval;
        }
    }
}

