/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.icatch.jta.template;

import com.atomikos.icatch.jta.template.TransactionTemplate;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.concurrent.Callable;
import javax.transaction.TransactionManager;

class RequiresNewTemplate
extends TransactionTemplate {
    public RequiresNewTemplate(TransactionManager utm, int timeout) {
        super(utm, timeout);
    }

    @Override
    public <T> T execute(Callable<T> work) throws Exception {
        T ret = null;
        try {
            this.suspendExistingTransaction();
            this.beginTransaction();
            ret = work.call();
            this.commitTransactionIfStartedHere();
        }
        catch (Exception e) {
            this.forceRollback(e);
            throw e;
        }
        catch (Throwable e) {
            this.forceRollback(e);
            throw new UndeclaredThrowableException(e);
        }
        finally {
            this.resumeExistingTransaction();
        }
        return ret;
    }
}

