/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.datasource.pool;

import com.atomikos.datasource.pool.ConnectionPoolProperties;
import com.atomikos.datasource.pool.CreateConnectionException;
import com.atomikos.datasource.pool.Reapable;
import com.atomikos.datasource.pool.XPooledConnection;
import com.atomikos.datasource.pool.XPooledConnectionEventListener;
import com.atomikos.logging.Logger;
import com.atomikos.logging.LoggerFactory;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractXPooledConnection
implements XPooledConnection {
    private static final Logger LOGGER = LoggerFactory.createLogger(AbstractXPooledConnection.class);
    private long lastTimeAcquired = System.currentTimeMillis();
    private long lastTimeReleased = System.currentTimeMillis();
    private List<XPooledConnectionEventListener> poolEventListeners = new ArrayList<XPooledConnectionEventListener>();
    private Reapable currentProxy = null;
    private ConnectionPoolProperties props;
    private long creationTime = System.currentTimeMillis();

    protected AbstractXPooledConnection(ConnectionPoolProperties props) {
        this.props = props;
    }

    @Override
    public long getLastTimeAcquired() {
        return this.lastTimeAcquired;
    }

    @Override
    public long getLastTimeReleased() {
        return this.lastTimeReleased;
    }

    @Override
    public synchronized Reapable createConnectionProxy() throws CreateConnectionException {
        this.updateLastTimeAcquired();
        this.testUnderlyingConnection();
        this.currentProxy = this.doCreateConnectionProxy();
        if (LOGGER.isTraceEnabled()) {
            LOGGER.logTrace(this + ": returning proxy " + this.currentProxy);
        }
        return this.currentProxy;
    }

    @Override
    public void reap() {
        if (this.currentProxy != null) {
            LOGGER.logWarning(this + ": reaping connection...");
            this.currentProxy.reap();
        }
        this.updateLastTimeReleased();
    }

    @Override
    public void registerXPooledConnectionEventListener(XPooledConnectionEventListener listener) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.logTrace(this + ": registering listener " + listener);
        }
        this.poolEventListeners.add(listener);
    }

    @Override
    public void unregisterXPooledConnectionEventListener(XPooledConnectionEventListener listener) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.logTrace(this + ": unregistering listener " + listener);
        }
        this.poolEventListeners.remove(listener);
    }

    protected void fireOnXPooledConnectionTerminated() {
        for (int i = 0; i < this.poolEventListeners.size(); ++i) {
            XPooledConnectionEventListener listener = this.poolEventListeners.get(i);
            if (LOGGER.isTraceEnabled()) {
                LOGGER.logTrace(this + ": notifying listener: " + listener);
            }
            listener.onXPooledConnectionTerminated(this);
        }
        this.updateLastTimeReleased();
    }

    protected String getTestQuery() {
        return this.props.getTestQuery();
    }

    protected void updateLastTimeReleased() {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.logTrace(this + ": updating last time released");
        }
        this.lastTimeReleased = System.currentTimeMillis();
    }

    private void updateLastTimeAcquired() {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.logTrace(this + ": updating last time acquired");
        }
        this.lastTimeAcquired = System.currentTimeMillis();
    }

    protected Reapable getCurrentConnectionProxy() {
        return this.currentProxy;
    }

    @Override
    public boolean canBeRecycledForCallingThread() {
        return false;
    }

    protected int getDefaultIsolationLevel() {
        return this.props.getDefaultIsolationLevel();
    }

    @Override
    public long getCreationTime() {
        return this.creationTime;
    }

    protected abstract Reapable doCreateConnectionProxy() throws CreateConnectionException;

    protected abstract void testUnderlyingConnection() throws CreateConnectionException;
}

