/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.jms;

import com.atomikos.datasource.TransactionalResource;
import com.atomikos.icatch.jta.TransactionManagerImp;
import com.atomikos.icatch.system.Configuration;
import com.atomikos.jms.DefaultJtaSession;
import javax.jms.Connection;
import javax.jms.ConnectionConsumer;
import javax.jms.ConnectionMetaData;
import javax.jms.Destination;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.ServerSessionPool;
import javax.jms.Session;
import javax.jms.Topic;
import javax.jms.XAConnection;
import javax.jms.XASession;
import javax.transaction.SystemException;
import javax.transaction.TransactionManager;

class DefaultJtaConnection
implements Connection {
    private XAConnection conn_;
    private TransactionalResource res_;

    protected static void forceConnectionIntoXaMode(Connection connection) {
        try {
            Session session = connection.createSession(true, 1);
            session.rollback();
            session.close();
        }
        catch (Exception exception) {
            Configuration.logDebug((String)"JMS: error forcing connection into global tx mode", (Exception)exception);
        }
    }

    protected static boolean inJtaTransaction() throws JMSException {
        boolean bl = false;
        TransactionManager transactionManager = TransactionManagerImp.getTransactionManager();
        if (transactionManager != null) {
            try {
                bl = transactionManager.getStatus() == 0;
            }
            catch (SystemException systemException) {
                Configuration.logWarning((String)"Could not determine transaction status: ", (Exception)((Object)systemException));
                JMSException jMSException = new JMSException("Could not determine transaction status - see linked exception for more info");
                jMSException.setLinkedException((Exception)((Object)systemException));
                throw jMSException;
            }
        }
        return bl;
    }

    protected DefaultJtaConnection(XAConnection xAConnection, TransactionalResource transactionalResource) {
        this.conn_ = xAConnection;
        this.res_ = transactionalResource;
    }

    protected TransactionalResource getTransactionalResource() {
        return this.res_;
    }

    protected Connection getConnection() {
        return this.conn_;
    }

    public void close() throws JMSException {
        this.conn_.close();
    }

    public void start() throws JMSException {
        this.conn_.start();
    }

    public void setExceptionListener(ExceptionListener exceptionListener) throws JMSException {
        this.conn_.setExceptionListener(exceptionListener);
    }

    public ExceptionListener getExceptionListener() throws JMSException {
        return this.conn_.getExceptionListener();
    }

    public ConnectionMetaData getMetaData() throws JMSException {
        return this.conn_.getMetaData();
    }

    public void setClientID(String string) throws JMSException {
        this.conn_.setClientID(string);
    }

    public String getClientID() throws JMSException {
        return this.conn_.getClientID();
    }

    public void stop() throws JMSException {
        this.conn_.stop();
    }

    public ConnectionConsumer createConnectionConsumer(Destination destination, String string, ServerSessionPool serverSessionPool, int n) throws JMSException {
        throw new JMSException("Not supported");
    }

    public ConnectionConsumer createDurableConnectionConsumer(Topic topic, String string, String string2, ServerSessionPool serverSessionPool, int n) throws JMSException {
        throw new JMSException("Not supported");
    }

    public Session createSession(boolean bl, int n) throws JMSException {
        Session session = null;
        if (!bl && !DefaultJtaConnection.inJtaTransaction()) {
            session = this.conn_.createSession(false, n);
        } else {
            DefaultJtaConnection.forceConnectionIntoXaMode((Connection)this.conn_);
            XASession xASession = this.conn_.createXASession();
            session = new DefaultJtaSession(xASession, this.res_, xASession.getXAResource());
        }
        return session;
    }
}

