/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.jms;

import com.atomikos.jms.AbstractBridge;
import java.io.Serializable;
import java.util.Enumeration;
import javax.jms.BytesMessage;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageEOFException;
import javax.jms.ObjectMessage;
import javax.jms.StreamMessage;
import javax.jms.TextMessage;

public class Bridge
extends AbstractBridge {
    protected Message bridgeMessage(Message message) throws JMSException {
        TextMessage textMessage = null;
        if (message instanceof TextMessage) {
            String string = ((TextMessage)message).getText();
            TextMessage textMessage2 = this.createTextMessage();
            textMessage2.setText(string);
            textMessage = textMessage2;
        } else if (message instanceof MapMessage) {
            MapMessage mapMessage = this.createMapMessage();
            MapMessage mapMessage2 = (MapMessage)message;
            Enumeration enumeration = mapMessage2.getMapNames();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                Object object = mapMessage2.getObject(string);
                mapMessage.setObject(string, object);
            }
            textMessage = mapMessage;
        } else if (message instanceof ObjectMessage) {
            ObjectMessage objectMessage = this.createObjectMessage();
            Serializable serializable = ((ObjectMessage)message).getObject();
            objectMessage.setObject(serializable);
            textMessage = objectMessage;
        } else if (message instanceof StreamMessage) {
            StreamMessage streamMessage = this.createStreamMessage();
            StreamMessage streamMessage2 = (StreamMessage)message;
            Object object = null;
            do {
                object = null;
                try {
                    object = streamMessage2.readObject();
                    if (object == null) continue;
                    streamMessage.writeObject(object);
                }
                catch (MessageEOFException messageEOFException) {
                    // empty catch block
                }
            } while (object != null);
            textMessage = streamMessage;
        } else if (message instanceof BytesMessage) {
            BytesMessage bytesMessage = this.createBytesMessage();
            BytesMessage bytesMessage2 = (BytesMessage)message;
            byte[] byArray = new byte[100];
            int n = bytesMessage2.readBytes(byArray);
            while (n >= 0) {
                bytesMessage.writeBytes(byArray, 0, n);
                n = bytesMessage2.readBytes(byArray);
            }
            textMessage = bytesMessage;
        } else {
            textMessage = this.createTextMessage();
        }
        this.copyHeadersAndProperties(message, (Message)textMessage);
        return textMessage;
    }
}

