/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.jdbc;

import com.atomikos.datasource.TransactionalResource;
import com.atomikos.datasource.xa.XAResourceTransaction;
import com.atomikos.icatch.CompositeTransaction;
import com.atomikos.icatch.CompositeTransactionManager;
import com.atomikos.icatch.system.Configuration;
import com.atomikos.jdbc.AtomikosSQLException;
import com.atomikos.jdbc.DTPPooledConnection;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

class ConnectionProxy
implements InvocationHandler {
    private static final List NON_TRANSACTIONAL_METHOD_NAMES = Arrays.asList("equals", "hashCode", "notify", "notifyAll", "toString", "wait");
    private Connection wrapped_;
    private TransactionalResource resource_;
    private DTPPooledConnection pc_;

    static Set getAllImplementedInterfaces(Class clazz) {
        HashSet hashSet = null;
        hashSet = clazz.getSuperclass() != null ? ConnectionProxy.getAllImplementedInterfaces(clazz.getSuperclass()) : new HashSet();
        Class<?>[] classArray = clazz.getInterfaces();
        for (int i = 0; i < classArray.length; ++i) {
            hashSet.add(classArray[i]);
        }
        return hashSet;
    }

    static Object newInstance(DTPPooledConnection dTPPooledConnection, Connection connection, TransactionalResource transactionalResource) throws SQLException {
        Object object = null;
        ConnectionProxy connectionProxy = new ConnectionProxy(connection, transactionalResource, dTPPooledConnection);
        Set set = ConnectionProxy.getAllImplementedInterfaces(connection.getClass());
        Class[] classArray = set.toArray(new Class[0]);
        object = Proxy.newProxyInstance(connection.getClass().getClassLoader(), classArray, (InvocationHandler)connectionProxy);
        return object;
    }

    private ConnectionProxy(Connection connection, TransactionalResource transactionalResource, DTPPooledConnection dTPPooledConnection) {
        this.wrapped_ = connection;
        this.resource_ = transactionalResource;
        this.pc_ = dTPPooledConnection;
    }

    public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
        if (NON_TRANSACTIONAL_METHOD_NAMES.contains(method.getName())) {
            Configuration.logDebug((String)("Calling non-transactional method '" + method.getName() + "' on connection proxy, bypassing enlistment"));
            return method.invoke((Object)this.wrapped_, objectArray);
        }
        Object object2 = null;
        XAResourceTransaction xAResourceTransaction = null;
        CompositeTransaction compositeTransaction = null;
        CompositeTransactionManager compositeTransactionManager = null;
        compositeTransactionManager = Configuration.getCompositeTransactionManager();
        boolean bl = false;
        if (compositeTransactionManager != null) {
            compositeTransaction = compositeTransactionManager.getCompositeTransaction();
        }
        bl = this.pc_.isInResourceTransaction();
        if (compositeTransaction != null && compositeTransaction.getProperty("com.atomikos.icatch.jta.transaction") != null && !this.pc_.isDiscarded() && !bl) {
            xAResourceTransaction = (XAResourceTransaction)this.resource_.getResourceTransaction(compositeTransaction);
            this.pc_.setResourceTransaction(xAResourceTransaction);
            xAResourceTransaction.resume();
            Configuration.logDebug((String)("JDBC ConnectionProxy: using resource transaction: " + xAResourceTransaction.getXid()));
        }
        try {
            Configuration.logDebug((String)("JDBC ConnectionProxy: delegating " + method.getName() + " to connection " + this.wrapped_.toString()));
            object2 = method.invoke((Object)this.wrapped_, objectArray);
        }
        catch (InvocationTargetException invocationTargetException) {
            this.pc_.setInvalidated();
            this.pc_.close();
            Configuration.logDebug((String)"Exception in pooled connection - closing it", (Exception)invocationTargetException);
            throw new AtomikosSQLException(invocationTargetException);
        }
        catch (Exception exception) {
            String string = "Exception in pooled connection: unexpected error - closing it";
            Configuration.logWarning((String)string, (Exception)exception);
            this.pc_.setInvalidated();
            this.pc_.close();
            throw new AtomikosSQLException(exception);
        }
        return object2;
    }
}

