/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.jdbc;

import com.atomikos.icatch.system.Configuration;
import com.atomikos.jdbc.ConnectionFactory;
import com.atomikos.jdbc.XPooledConnection;
import java.io.PrintWriter;
import java.sql.SQLException;
import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;
import javax.sql.PooledConnection;

public class ConnectionPool
implements Runnable {
    private long timeout_;
    private Vector pool_;
    private int maxSize_;
    private ConnectionFactory source_;
    private boolean timerNeeded_ = true;
    private String testQuery_;
    private boolean testOnBorrow_;

    public ConnectionPool(int n, ConnectionFactory connectionFactory, int n2, String string, boolean bl) throws SQLException {
        this.testQuery_ = string;
        this.timeout_ = n2 * 1000;
        this.source_ = connectionFactory;
        this.pool_ = new Vector();
        this.maxSize_ = n;
        this.testOnBorrow_ = bl;
        for (int i = 0; i < this.maxSize_; ++i) {
            XPooledConnection xPooledConnection = this.source_.getPooledConnection();
            if (xPooledConnection == null) {
                throw new SQLException("ConnectionPool constructor: null PooledConnection");
            }
            this.pool_.addElement(xPooledConnection);
        }
        Thread thread = new Thread(this);
        thread.setDaemon(true);
        thread.start();
    }

    public int getSize() {
        return this.pool_.size();
    }

    public synchronized PooledConnection getPooledConnection() throws SQLException {
        PooledConnection pooledConnection;
        if (this.pool_.isEmpty()) {
            pooledConnection = this.source_.getPooledConnection();
            Configuration.logWarning((String)("JDBC ConnectionPool exhausted - allocated new connection: " + ((Object)pooledConnection).toString()));
            if (this.testOnBorrow_) {
                this.test(pooledConnection, false);
            }
        } else {
            pooledConnection = (XPooledConnection)this.pool_.firstElement();
            if (!this.pool_.removeElement(pooledConnection)) {
                throw new SQLException("Unable to take connection out of pool?");
            }
            if (this.testOnBorrow_) {
                try {
                    this.test(pooledConnection, false);
                }
                catch (SQLException sQLException) {
                    pooledConnection = this.getPooledConnection();
                }
            }
        }
        Configuration.logDebug((String)("JDBC ConnectionPool: using connection: " + pooledConnection));
        return pooledConnection;
    }

    protected synchronized void putInPool(PooledConnection pooledConnection) {
        this.pool_.addElement(pooledConnection);
        this.notifyAll();
    }

    public synchronized void putBack(XPooledConnection xPooledConnection) {
        if (!xPooledConnection.getInvalidated() && this.getSize() < this.maxSize_) {
            Configuration.logDebug((String)("Putting connection back in pool: " + ((Object)xPooledConnection).toString()));
            this.putInPool(xPooledConnection);
        } else {
            try {
                Configuration.logDebug((String)("Pool: closing connection: " + ((Object)xPooledConnection).toString()));
                xPooledConnection.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    protected synchronized Enumeration getOldConnections() {
        Vector<XPooledConnection> vector = new Vector<XPooledConnection>();
        Date date = new Date();
        Enumeration enumeration = this.pool_.elements();
        while (enumeration.hasMoreElements()) {
            XPooledConnection xPooledConnection = (XPooledConnection)enumeration.nextElement();
            if (date.getTime() - xPooledConnection.getLastUse().getTime() <= this.timeout_) continue;
            vector.addElement(xPooledConnection);
        }
        enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            this.pool_.removeElement(enumeration.nextElement());
        }
        return vector.elements();
    }

    public void run() {
        try {
            while (this.timerNeeded_) {
                Thread.sleep(this.timeout_);
                Enumeration enumeration = this.getOldConnections();
                while (this.timerNeeded_ && enumeration.hasMoreElements()) {
                    XPooledConnection xPooledConnection = (XPooledConnection)enumeration.nextElement();
                    try {
                        if (!xPooledConnection.getInvalidated()) {
                            this.test(xPooledConnection, true);
                            Configuration.logDebug((String)("ConnectionPool: connection is fine, keeping it in pool: " + xPooledConnection));
                            this.putInPool(xPooledConnection);
                            continue;
                        }
                        if (this.getSize() >= this.maxSize_) continue;
                        XPooledConnection xPooledConnection2 = this.source_.getPooledConnection();
                        this.putInPool(xPooledConnection2);
                        Configuration.logDebug((String)("ConnectionPool: replacing invalidated connection " + ((Object)xPooledConnection).toString()));
                    }
                    catch (SQLException sQLException) {
                        if (this.getSize() >= this.maxSize_) continue;
                        XPooledConnection xPooledConnection3 = this.source_.getPooledConnection();
                        this.putInPool(xPooledConnection3);
                        Configuration.logDebug((String)("ConnectionPool: connection invalid, replacing it: " + ((Object)xPooledConnection).toString()), (Exception)sQLException);
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void test(PooledConnection var1_1, boolean var2_2) throws SQLException {
        var3_3 = null;
        var4_4 = false;
        try {
            block12: {
                var3_3 = var1_1.getConnection();
                if (this.testQuery_ != null && !"".equals(this.testQuery_)) break block12;
                Configuration.logDebug((String)("ConnectionPool: no query to test connection, trying getMetaData(): " + var3_3));
                var3_3.getMetaData();
                var8_5 = null;
                ** GOTO lbl36
            }
            Configuration.logDebug((String)("ConnectionPool: trying query '" + this.testQuery_ + "' on connection " + var3_3));
            var5_11 = var3_3.createStatement();
            var6_13 = var5_11.executeQuery(this.testQuery_);
            var6_13.close();
            var5_11.close();
            ** GOTO lbl45
        }
        catch (SQLException var5_12) {
            Configuration.logWarning((String)"ConnectionPool: error testing connection", (Exception)var5_12);
            var4_4 = true;
            throw var5_12;
        }
        {
            catch (Throwable var7_14) {
                var8_7 = null;
                try {
                    if (var3_3 != null && (var2_2 || var4_4)) {
                        var3_3.close();
                    }
                    if (var4_4 == false) throw var7_14;
                    var1_1.close();
                    throw var7_14;
                }
                catch (SQLException var9_10) {
                    Configuration.logWarning((String)"ConnectionPool: error closing connection during test", (Exception)var9_10);
                }
                throw var7_14;
            }
lbl36:
            // 1 sources

            ** try [egrp 2[TRYBLOCK] [5 : 164->197)] { 
lbl37:
            // 1 sources

            if (var3_3 != null && (var2_2 || var4_4)) {
                var3_3.close();
            }
            if (var4_4 == false) return;
            var1_1.close();
            return;
lbl42:
            // 1 sources

            catch (SQLException var9_8) {
                Configuration.logWarning((String)"ConnectionPool: error closing connection during test", (Exception)var9_8);
            }
            return;
lbl45:
            // 1 sources

            var8_6 = null;
            try {}
            catch (SQLException var9_9) {}
            Configuration.logWarning((String)"ConnectionPool: error closing connection during test", (Exception)var9_9);
            return;
            if (var3_3 != null && (var2_2 || var4_4)) {
                var3_3.close();
            }
            if (var4_4 == false) return;
            var1_1.close();
            return;
        }
    }

    public synchronized void cleanup() {
        this.timerNeeded_ = false;
        if (this.pool_ == null) {
            return;
        }
        Enumeration enumeration = this.pool_.elements();
        try {
            while (enumeration.hasMoreElements()) {
                PooledConnection pooledConnection = (PooledConnection)enumeration.nextElement();
                pooledConnection.close();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        this.pool_ = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finalize() throws Throwable {
        try {
            this.cleanup();
        }
        finally {
            super.finalize();
        }
    }

    public PrintWriter getLogWriter() throws SQLException {
        return this.source_.getLogWriter();
    }

    public void setLogWriter(PrintWriter printWriter) throws SQLException {
        this.source_.setLogWriter(printWriter);
    }

    public void setLoginTimeout(int n) throws SQLException {
        this.source_.setLoginTimeout(n);
    }

    public int getLoginTimeout() throws SQLException {
        return this.source_.getLoginTimeout();
    }
}

