/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.datasource.xa;

import com.atomikos.datasource.ResourceException;
import com.atomikos.datasource.xa.OraXidFactory;
import com.atomikos.datasource.xa.XATransactionalResource;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;

public class TemporaryXATransactionalResource
extends XATransactionalResource {
    private static final int MAX_BYTES = 45;

    private static final String truncateNameTo45Bytes(String string) {
        String string2 = string;
        if (string2.getBytes().length > 45) {
            string2 = string.substring(0, 45);
        }
        if (string2.getBytes().length > 45) {
            string2 = string.substring(0, 22);
        }
        return string2;
    }

    public TemporaryXATransactionalResource(XAResource xAResource) {
        super(TemporaryXATransactionalResource.truncateNameTo45Bytes(xAResource.toString()));
        this.xares_ = xAResource;
        this.getXAResource();
        if (xAResource.getClass().getName().toLowerCase().indexOf("oracle") >= 0) {
            this.setXidFactory(new OraXidFactory());
        }
        try {
            if (!xAResource.isSameRM(xAResource)) {
                this.printMsg("XAResource " + xAResource + " of class " + xAResource.getClass().getName() + " does not correctly implement isSameRM(): " + "use explicit resource registration to save memory.", 1);
            }
        }
        catch (XAException xAException) {
            // empty catch block
        }
    }

    protected XAResource refreshXAConnection() throws ResourceException {
        return this.xares_;
    }

    public boolean isClosed() {
        return this.needsRefresh();
    }
}

