/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.jms.extra;

import com.atomikos.jms.internal.AtomikosJMSException;
import com.atomikos.logging.Logger;
import com.atomikos.logging.LoggerFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.Session;

class DestinationHelper {
    private static final Logger LOGGER = LoggerFactory.createLogger(DestinationHelper.class);

    DestinationHelper() {
    }

    public static Destination findDestination(String destinationName, Session session) throws JMSException {
        Queue destination;
        block7: {
            block6: {
                destination = null;
                try {
                    destination = session.createQueue(destinationName);
                }
                catch (Exception failed) {
                    if (!LOGGER.isTraceEnabled()) break block6;
                    LOGGER.logTrace("Failed to find queue with name: " + destinationName, (Throwable)failed);
                }
            }
            if (destination == null) {
                try {
                    destination = session.createTopic(destinationName);
                }
                catch (Exception failed) {
                    if (!LOGGER.isTraceEnabled()) break block7;
                    LOGGER.logTrace("Failed to find topic with name: " + destinationName, (Throwable)failed);
                }
            }
        }
        if (destination == null) {
            AtomikosJMSException.throwAtomikosJMSException("The specified destination could not be found: " + destinationName);
        }
        return destination;
    }
}

