/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.jms.internal;

import com.atomikos.datasource.xa.session.SessionHandleStateChangeListener;
import com.atomikos.icatch.CompositeTransaction;
import com.atomikos.icatch.jta.TransactionManagerImp;
import com.atomikos.jms.internal.AbstractJmsSessionProxy;
import com.atomikos.jms.internal.AtomikosJmsConnectionProxy;
import com.atomikos.logging.Logger;
import com.atomikos.logging.LoggerFactory;
import com.atomikos.util.Proxied;
import java.lang.reflect.Method;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import javax.jms.Session;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;

public class AtomikosJmsNonXaSessionProxy
extends AbstractJmsSessionProxy {
    private static final Logger LOGGER = LoggerFactory.createLogger(AtomikosJmsNonXaSessionProxy.class);
    private boolean errorsOccurred = false;
    private final SessionHandleStateChangeListener owner;
    private final SessionHandleStateChangeListener connectionProxy;

    public AtomikosJmsNonXaSessionProxy(Session delegate, SessionHandleStateChangeListener owner, SessionHandleStateChangeListener connectionProxy) {
        super(delegate);
        this.owner = owner;
        this.connectionProxy = connectionProxy;
    }

    protected void throwInvocationAfterClose(String methodName) throws Exception {
        String msg = "session was closed already - calling " + methodName + " is no longer allowed.";
        LOGGER.logWarning((Object)((Object)this) + ": " + msg);
        throw new IllegalStateException(msg);
    }

    @Proxied
    public void close() {
        this.destroy();
        this.markClosed();
    }

    public synchronized Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        this.checkForTransactionContextAndLogWarningIfSo();
        return super.invoke(proxy, method, args);
    }

    private void checkForTransactionContextAndLogWarningIfSo() {
        TransactionManager tm = TransactionManagerImp.getTransactionManager();
        if (tm != null) {
            Transaction tx;
            block5: {
                tx = null;
                try {
                    tx = tm.getTransaction();
                }
                catch (SystemException e) {
                    if (!LOGGER.isTraceEnabled()) break block5;
                    LOGGER.logTrace((Object)((Object)this) + ": failed to get transaction.", (Throwable)e);
                }
            }
            if (tx != null) {
                String msg = (Object)((Object)this) + ": WARNING - detected JTA transaction context while using non-transactional session.\nBeware that any JMS operations you perform are NOT part of the JTA transaction.\nTo enable JTA, make sure to do all of the following:\n1. Make sure that the AtomikosConnectionFactoryBean is configured with localTransactionMode=false, and\n2. Make sure to call create JMS sessions with the transacted flag set to true.";
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.logDebug(msg);
                }
            }
        }
    }

    protected void destroy() {
        try {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.logDebug((Object)((Object)this) + ": destroying session...");
            }
            if (!this.closed) {
                this.closed = true;
                ((Session)this.delegate).close();
                this.owner.onTerminated();
                this.connectionProxy.onTerminated();
            }
        }
        catch (JMSException e) {
            LOGGER.logWarning((Object)((Object)this) + ": could not close JMS session", (Throwable)e);
        }
    }

    @Override
    protected boolean isAvailable() {
        return this.closed;
    }

    @Override
    protected boolean isErroneous() {
        return this.errorsOccurred;
    }

    @Override
    protected boolean isInTransaction(CompositeTransaction ct) {
        return false;
    }

    public String toString() {
        return "atomikosJmsNonXaSessionProxy (isAvailable = " + this.closed + ") for vendor instance " + this.delegate;
    }

    public static Session newInstance(Session wrapped, SessionHandleStateChangeListener owner, AtomikosJmsConnectionProxy atomikosJmsConnectionProxy) {
        AtomikosJmsNonXaSessionProxy proxy = new AtomikosJmsNonXaSessionProxy(wrapped, owner, atomikosJmsConnectionProxy);
        return (Session)proxy.createDynamicProxy();
    }

    @Override
    public void recycle() {
        LOGGER.logWarning((Object)((Object)this) + ": unexpected call of recycle() - this is probably a bug?");
    }

    protected void handleInvocationException(Throwable e) throws Throwable {
        this.errorsOccurred = true;
        throw e;
    }
}

