/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.jms;

import com.atomikos.jms.AtomikosJMSException;
import com.atomikos.logging.Logger;
import com.atomikos.logging.LoggerFactory;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import javax.jms.JMSException;

abstract class AbstractJmsProxy
implements InvocationHandler {
    private static final Logger LOGGER = LoggerFactory.createLogger(AbstractJmsProxy.class);

    AbstractJmsProxy() {
    }

    protected void convertProxyError(Throwable ex, String msg) throws JMSException {
        if (ex instanceof Error) {
            Error err = (Error)ex;
            LOGGER.logWarning(msg, (Throwable)err);
            throw err;
        }
        if (ex instanceof RuntimeException) {
            RuntimeException rte = (RuntimeException)ex;
            LOGGER.logWarning(msg, ex);
            throw rte;
        }
        if (ex instanceof JMSException) {
            JMSException driverError = (JMSException)ex;
            LOGGER.logWarning(msg, ex);
            Exception linkedException = driverError.getLinkedException();
            if (linkedException != null) {
                LOGGER.logWarning("linked exception is ", (Throwable)linkedException);
            }
            throw driverError;
        }
        if (ex instanceof InvocationTargetException) {
            InvocationTargetException ite = (InvocationTargetException)ex;
            Throwable cause = ite.getCause();
            if (cause != null) {
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.logTrace(msg, (Throwable)ite);
                }
                this.convertProxyError(cause, msg);
            } else {
                AtomikosJMSException.throwAtomikosJMSException(msg, ite);
            }
        }
        AtomikosJMSException.throwAtomikosJMSException(msg, ex);
    }
}

