/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.jms;

import com.atomikos.datasource.xa.session.SessionHandleState;
import com.atomikos.jms.ConsumerProducerSupport;
import com.atomikos.jms.HeuristicMessageProducer;
import com.atomikos.logging.Logger;
import com.atomikos.logging.LoggerFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;

class AtomikosJmsMessageProducerProxy
extends ConsumerProducerSupport
implements HeuristicMessageProducer {
    private static final Logger LOGGER = LoggerFactory.createLogger(AtomikosJmsMessageProducerProxy.class);
    private MessageProducer delegate;

    AtomikosJmsMessageProducerProxy(MessageProducer delegate, SessionHandleState state) {
        super(state);
        this.delegate = delegate;
    }

    @Override
    public void send(Message msg, String heuristicMessage) throws JMSException {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.logInfo(this + ": send ( message , heuristicMessage )...");
        }
        this.enlist();
        this.delegate.send(msg);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.logDebug(this + ": send done.");
        }
    }

    @Override
    public void send(Destination dest, Message msg, String heuristicMessage) throws JMSException {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.logInfo(this + ": send ( destination , message , heuristicMessage )...");
        }
        this.enlist();
        this.delegate.send(dest, msg);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.logDebug(this + ": send done.");
        }
    }

    @Override
    public void send(Message msg, int deliveryMode, int priority, long timeToLive, String heuristicMessage) throws JMSException {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.logInfo(this + ": send ( message , deliveryMode , priority , timeToLive , heuristicMessage )...");
        }
        this.enlist();
        this.delegate.send(msg, deliveryMode, priority, timeToLive);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.logDebug(this + ": send done.");
        }
    }

    @Override
    public void send(Destination dest, Message msg, int deliveryMode, int priority, long timeToLive, String heuristicMessage) throws JMSException {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.logInfo(this + ": send ( destination , message , deliveryMode , priority , timeToLive , heuristicMessage )...");
        }
        this.enlist();
        this.delegate.send(dest, msg, deliveryMode, priority, timeToLive);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.logDebug(this + ": send done.");
        }
    }

    public void close() throws JMSException {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.logInfo(this + ": close...");
        }
        this.delegate.close();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.logDebug(this + ": close done.");
        }
    }

    public int getDeliveryMode() throws JMSException {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.logInfo(this + ": getDeliveryMode()...");
        }
        int ret = this.delegate.getDeliveryMode();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.logDebug(this + ": getDeliveryMode() returning " + ret);
        }
        return ret;
    }

    public Destination getDestination() throws JMSException {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.logInfo(this + ": getDestination()...");
        }
        Destination ret = this.delegate.getDestination();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.logDebug(this + ": getDestination() returning " + ret);
        }
        return ret;
    }

    public boolean getDisableMessageID() throws JMSException {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.logInfo(this + ": getDisableMessageID()...");
        }
        boolean ret = this.delegate.getDisableMessageID();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.logDebug(this + ": getDisableMessageID() returning " + ret);
        }
        return ret;
    }

    public boolean getDisableMessageTimestamp() throws JMSException {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.logInfo(this + ": getDisableMessageTimestamp()...");
        }
        boolean ret = this.delegate.getDisableMessageTimestamp();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.logDebug(this + ": getDisableMessageTimestamp() returning " + ret);
        }
        return ret;
    }

    public int getPriority() throws JMSException {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.logInfo(this + ": getPriority()...");
        }
        int ret = this.delegate.getPriority();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.logDebug(this + ": getPriority() returning " + ret);
        }
        return ret;
    }

    public long getTimeToLive() throws JMSException {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.logInfo(this + ": getTimeToLive()...");
        }
        long ret = this.delegate.getTimeToLive();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.logDebug(this + ": getTimeToLive() returning " + ret);
        }
        return ret;
    }

    public void send(Message msg) throws JMSException {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.logInfo(this + ": send ( message )...");
        }
        this.send(msg, null);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.logDebug(this + ": send done.");
        }
    }

    public void send(Destination dest, Message msg) throws JMSException {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.logInfo(this + ": send ( destination , message )...");
        }
        this.send(dest, msg, null);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.logDebug(this + ": send done.");
        }
    }

    public void send(Message msg, int deliveryMode, int pty, long ttl) throws JMSException {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.logInfo(this + ": send ( message , deliveryMode , priority , timeToLive )...");
        }
        this.send(msg, deliveryMode, pty, ttl, null);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.logDebug(this + ": send done.");
        }
    }

    public void send(Destination dest, Message msg, int mode, int pty, long ttl) throws JMSException {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.logInfo(this + ": send ( destination , message , deliveryMode , priority , timeToLive )...");
        }
        this.send(dest, msg, mode, pty, ttl, null);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.logDebug(this + ": send done.");
        }
    }

    public void setDeliveryMode(int mode) throws JMSException {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.logInfo(this + ": setDeliveryMode ( " + mode + " )...");
        }
        this.delegate.setDeliveryMode(mode);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.logDebug(this + ": setDeliveryMode done.");
        }
    }

    public void setDisableMessageID(boolean mode) throws JMSException {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.logInfo(this + ": setDisableMessageID ( " + mode + " )...");
        }
        this.delegate.setDisableMessageID(mode);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.logDebug(this + ": setDisableMessageID done.");
        }
    }

    public void setDisableMessageTimestamp(boolean mode) throws JMSException {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.logInfo(this + ": setDisableMessageTimestamp ( " + mode + " )...");
        }
        this.delegate.setDisableMessageTimestamp(mode);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.logDebug(this + ": setDisableMessageTimestamp done.");
        }
    }

    public void setPriority(int pty) throws JMSException {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.logInfo(this + ": setPriority ( " + pty + " )...");
        }
        this.delegate.setPriority(pty);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.logDebug(this + ": setPriority done.");
        }
    }

    public void setTimeToLive(long ttl) throws JMSException {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.logInfo(this + ": setTimeToLive ( " + ttl + " )...");
        }
        this.delegate.setTimeToLive(ttl);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.logDebug(this + ": setTimeToLive done.");
        }
    }

    public String toString() {
        return "atomikos MessageProducer proxy for " + this.delegate;
    }
}

