/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.jdbc.internal;

import com.atomikos.datasource.pool.AbstractXPooledConnection;
import com.atomikos.datasource.pool.ConnectionPoolProperties;
import com.atomikos.datasource.pool.CreateConnectionException;
import com.atomikos.icatch.CompositeTransaction;
import com.atomikos.icatch.CompositeTransactionManager;
import com.atomikos.icatch.config.Configuration;
import com.atomikos.icatch.jta.TransactionManagerImp;
import com.atomikos.jdbc.internal.AbstractJdbcConnectionProxy;
import com.atomikos.jdbc.internal.JdbcConnectionProxyHelper;
import com.atomikos.jdbc.internal.JtaAwareThreadLocalConnection;
import com.atomikos.jdbc.internal.JtaUnawareThreadLocalConnection;
import com.atomikos.jdbc.internal.NonXaConnectionProxy;
import com.atomikos.logging.Logger;
import com.atomikos.logging.LoggerFactory;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;

public class AtomikosNonXAPooledConnection
extends AbstractXPooledConnection<Connection> {
    private static final Logger LOGGER = LoggerFactory.createLogger(AtomikosNonXAPooledConnection.class);
    private static boolean isJdbc4Compatible = true;
    private Connection connection;
    private boolean erroneous;
    private boolean readOnly;
    private ConnectionPoolProperties props;

    public AtomikosNonXAPooledConnection(Connection wrapped, ConnectionPoolProperties props, boolean readOnly) {
        super(props);
        this.connection = wrapped;
        this.erroneous = false;
        this.readOnly = readOnly;
        this.props = props;
    }

    void setErroneous() {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.logTrace((Object)((Object)this) + ": setErroneous");
        }
        this.erroneous = true;
    }

    public void doDestroy(boolean reap) {
        try {
            if (this.connection != null) {
                this.connection.close();
            }
        }
        catch (SQLException e) {
            LOGGER.logWarning((Object)((Object)this) + ": Error closing JDBC connection: ", (Throwable)e);
        }
    }

    protected Connection doCreateConnectionProxy() throws CreateConnectionException {
        Connection ret = null;
        if (this.canBeRecycledForCallingThread()) {
            if (LOGGER.isTraceEnabled()) {
                LOGGER.logTrace((Object)((Object)this) + ": reusing existing proxy for thread...");
            }
            ret = (Connection)this.getCurrentConnectionProxy();
        } else {
            AbstractJdbcConnectionProxy proxy;
            if (LOGGER.isTraceEnabled()) {
                LOGGER.logTrace((Object)((Object)this) + ": creating connection proxy...");
            }
            JdbcConnectionProxyHelper.setIsolationLevel(this.connection, this.getDefaultIsolationLevel());
            if (this.props.getLocalTransactionMode()) {
                proxy = new JtaUnawareThreadLocalConnection(this);
                ret = (Connection)proxy.createDynamicProxy();
            } else {
                proxy = new JtaAwareThreadLocalConnection(this, this.props.getUniqueResourceName());
                ret = (Connection)proxy.createDynamicProxy();
            }
        }
        InvocationHandler impl = Proxy.getInvocationHandler(ret);
        if (impl instanceof JtaAwareThreadLocalConnection) {
            JtaAwareThreadLocalConnection previous = (JtaAwareThreadLocalConnection)((Object)impl);
            previous.incUseCount();
        }
        return ret;
    }

    Connection getConnection() {
        return this.connection;
    }

    protected void testUnderlyingConnection() throws CreateConnectionException {
        String testQuery = this.getTestQuery();
        if (this.isErroneous()) {
            throw new CreateConnectionException((Object)((Object)this) + ": connection is erroneous");
        }
        if (this.maxLifetimeExceeded()) {
            throw new CreateConnectionException((Object)((Object)this) + ": connection too old - will be replaced");
        }
        int queryTimeout = Math.max(0, this.getBorrowConnectionTimeout());
        if (testQuery != null) {
            if (LOGGER.isTraceEnabled()) {
                LOGGER.logTrace((Object)((Object)this) + ": testing connection with query [" + testQuery + "]");
            }
            Statement stmt = null;
            try {
                stmt = this.connection.createStatement();
                stmt.setQueryTimeout(queryTimeout);
                stmt.execute(testQuery);
                stmt.close();
            }
            catch (Exception e) {
                throw new CreateConnectionException("Error executing testQuery", e);
            }
            if (LOGGER.isTraceEnabled()) {
                LOGGER.logTrace((Object)((Object)this) + ": connection tested OK");
            }
        } else if (isJdbc4Compatible) {
            if (LOGGER.isTraceEnabled()) {
                LOGGER.logTrace((Object)((Object)this) + ": testing connection with connection.isValid()");
            }
            try {
                if (!this.connection.isValid(queryTimeout)) {
                    throw new CreateConnectionException("Connection no longer valid");
                }
            }
            catch (CreateConnectionException e) {
                throw e;
            }
            catch (Throwable e) {
                LOGGER.logWarning("JDBC connection validation not supported by DBMS driver - please set a testQuery if validation is desired...", e);
                isJdbc4Compatible = false;
            }
        }
    }

    public boolean isAvailable() {
        boolean ret = true;
        Object handle = this.getCurrentConnectionProxy();
        if (handle != null) {
            NonXaConnectionProxy previous = (NonXaConnectionProxy)((Object)Proxy.getInvocationHandler(handle));
            ret = previous.isAvailableForReuseByPool();
        }
        return ret;
    }

    public boolean isErroneous() {
        return this.erroneous;
    }

    protected void fireOnXPooledConnectionTerminated() {
        super.fireOnXPooledConnectionTerminated();
        this.updateLastTimeReleased();
    }

    public String toString() {
        return "AtomikosNonXAPooledConnection";
    }

    public boolean getReadOnly() {
        return this.readOnly;
    }

    public boolean canBeRecycledForCallingThread() {
        boolean ret = false;
        Object handle = this.getCurrentConnectionProxy();
        if (handle != null && !this.props.getLocalTransactionMode()) {
            CompositeTransactionManager ctm = Configuration.getCompositeTransactionManager();
            CompositeTransaction ct = null;
            if (ctm != null) {
                ct = ctm.getCompositeTransaction();
            }
            if (ct != null && TransactionManagerImp.isJtaTransaction((CompositeTransaction)ct)) {
                JtaAwareThreadLocalConnection previous = (JtaAwareThreadLocalConnection)((Object)Proxy.getInvocationHandler(handle));
                ret = previous.isInTransaction(ct);
            }
        }
        return ret;
    }
}

