/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.jdbc.nonxa;

import com.atomikos.icatch.HeuristicMessage;
import com.atomikos.icatch.system.Configuration;
import com.atomikos.jdbc.HeuristicDataSource;
import com.atomikos.jdbc.nonxa.DataSourceShutdownHook;
import com.atomikos.jdbc.nonxa.DriverManagerDataSource;
import com.atomikos.jdbc.nonxa.NonXADataSourceImp;
import com.atomikos.logging.Logger;
import com.atomikos.logging.LoggerFactory;
import com.atomikos.util.SerializableObjectFactory;
import java.io.PrintWriter;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.sql.DataSource;

public class NonXADataSourceBean
implements HeuristicDataSource,
Referenceable,
Serializable {
    private static final Logger LOGGER = LoggerFactory.createLogger(NonXADataSourceBean.class);
    private String validatingQuery;
    private String jndiName = "some unique name";
    private String url = "";
    private String user = "";
    private String password = "";
    private String driverClassName = "";
    private int poolSize = 2;
    private int connectionTimeout = 15;
    private boolean testOnBorrow = false;
    private transient NonXADataSourceImp delegate;

    private synchronized void checkSetup(boolean validation) throws SQLException {
        this.delegate = NonXADataSourceImp.getInstance(this.jndiName);
        if (this.delegate != null && !validation) {
            return;
        }
        if (this.url == null || this.url.equals("")) {
            throw new SQLException("NonXADataSourceBean: url not set.");
        }
        if (this.driverClassName == null || this.driverClassName.equals("")) {
            throw new SQLException("NonXADataSourceBean: driverClassName not set.");
        }
        DriverManagerDataSource driver = new DriverManagerDataSource();
        driver.setDriverClassName(this.driverClassName);
        driver.setUser(this.user);
        driver.setPassword(this.password);
        driver.setUrl(this.url);
        this.delegate = new NonXADataSourceImp((DataSource)driver, this.jndiName, this.user, this.password, this.poolSize, this.connectionTimeout, validation, this.validatingQuery, this.testOnBorrow);
        DataSourceShutdownHook hook = new DataSourceShutdownHook(this.delegate);
        Configuration.addShutdownHook((Thread)hook);
        StringBuffer sb = new StringBuffer();
        sb.append("NonXADataSourceBean configured with [");
        sb.append("uniqueResourceName=").append(this.jndiName).append(", ");
        sb.append("url=").append(this.url).append(", ");
        sb.append("user=").append(this.user).append(", ");
        sb.append("password=").append(this.password).append(", ");
        sb.append("driverClassName=").append(this.driverClassName).append(", ");
        sb.append("poolSize=").append(this.poolSize).append(", ");
        sb.append("connectionTimeout=").append(this.connectionTimeout).append(", ");
        sb.append("testOnBorrow=").append(this.testOnBorrow);
        sb.append("]");
        if (LOGGER.isDebugEnabled()) {
            LOGGER.logDebug(sb.toString());
        }
        LOGGER.logWarning("WARNING: class " + this.getClass().getName() + " is deprecated!");
    }

    public Connection getConnection(HeuristicMessage msg) throws SQLException {
        this.checkSetup(false);
        return this.delegate.getConnection(msg);
    }

    public Connection getConnection(String user, String passwd, HeuristicMessage msg) throws SQLException {
        this.checkSetup(false);
        return this.delegate.getConnection(user, passwd, msg);
    }

    public Reference getReference() throws NamingException {
        return SerializableObjectFactory.createReference((Serializable)this);
    }

    public Connection getConnection() throws SQLException {
        this.checkSetup(false);
        return this.delegate.getConnection();
    }

    public Connection getConnection(String user, String pass) throws SQLException {
        this.checkSetup(false);
        return this.delegate.getConnection(user, pass);
    }

    public Connection getConnection(String msg) throws SQLException {
        this.checkSetup(false);
        return this.delegate.getConnection(msg);
    }

    public Connection getConnection(String user, String passwd, String msg) throws SQLException {
        this.checkSetup(false);
        return this.delegate.getConnection(user, passwd, msg);
    }

    public PrintWriter getLogWriter() throws SQLException {
        this.checkSetup(false);
        return this.delegate.getLogWriter();
    }

    public void setLogWriter(PrintWriter pw) throws SQLException {
        this.checkSetup(false);
        this.delegate.setLogWriter(pw);
    }

    public void setLoginTimeout(int val) throws SQLException {
        this.checkSetup(false);
        this.delegate.setLoginTimeout(val);
    }

    public int getLoginTimeout() throws SQLException {
        this.checkSetup(false);
        return this.delegate.getLoginTimeout();
    }

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public String getDriverClassName() {
        return this.driverClassName;
    }

    public String getUniqueResourceName() {
        return this.jndiName;
    }

    public String getPassword() {
        return this.password;
    }

    public int getPoolSize() {
        return this.poolSize;
    }

    public String getUrl() {
        return this.url;
    }

    public String getUser() {
        return this.user;
    }

    public void setTestOnBorrow(boolean value) {
        this.testOnBorrow = value;
    }

    public boolean getTestOnBorrow() {
        return this.testOnBorrow;
    }

    public void setConnectionTimeout(int secs) {
        this.connectionTimeout = secs;
    }

    public void setDriverClassName(String name) {
        this.driverClassName = name;
    }

    public void setUniqueResourceName(String name) {
        this.jndiName = name;
    }

    public void setPassword(String string) {
        this.password = string;
    }

    public void setPoolSize(int size) {
        this.poolSize = size;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setUser(String string) {
        this.user = string;
    }

    public void setValidatingQuery(String query) {
        this.validatingQuery = query;
    }

    public String getValidatingQuery() {
        return this.validatingQuery;
    }

    public void close() {
        if (this.delegate != null) {
            this.delegate.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validate() throws SQLException {
        this.checkSetup(true);
        String query = this.getValidatingQuery();
        if (query == null || query.equals("")) {
            return;
        }
        Connection c = null;
        Statement s = null;
        try {
            c = this.delegate.getConnection();
            try {
                s = c.createStatement();
                ResultSet rs = s.executeQuery(query);
                s.close();
            }
            finally {
                if (s != null) {
                    s.close();
                }
            }
        }
        finally {
            if (c != null) {
                c.close();
            }
        }
    }
}

