/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.jdbc;

import com.atomikos.datasource.ResourceTransaction;
import com.atomikos.datasource.TransactionalResource;
import com.atomikos.datasource.xa.LoggingXAResource;
import com.atomikos.datasource.xa.XAResourceTransaction;
import com.atomikos.icatch.HeuristicMessage;
import com.atomikos.icatch.TxState;
import com.atomikos.jdbc.ConnectionProxy;
import com.atomikos.jdbc.DTPPooledConnection;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.XAConnection;
import javax.transaction.xa.XAResource;

public class ExternalXAPooledConnectionImp
implements DTPPooledConnection,
ConnectionEventListener {
    protected Date lastUse_ = new Date();
    protected XAConnection myConn_;
    protected Vector listeners_ = new Vector();
    protected boolean invalidated_ = false;
    protected Date creationTime_ = new Date();
    protected boolean discarded_ = false;
    protected TransactionalResource resource_;
    protected XAResourceTransaction restx_;
    protected PrintWriter logWriter_;
    protected HeuristicMessage msg_;
    protected Connection connectionProxy_;

    protected static void suspendResourceTransaction(ResourceTransaction restx) {
        XAResourceTransaction xarestx = (XAResourceTransaction)restx;
        if (xarestx != null && !xarestx.getState().equals(TxState.TERMINATED)) {
            xarestx.suspend();
        }
    }

    public String toString() {
        return new String("ExternalXAPooledConnectionImp" + this.creationTime_.getTime() + super.toString());
    }

    public ExternalXAPooledConnectionImp(XAConnection c, TransactionalResource resource) {
        this.myConn_ = c;
        this.myConn_.addConnectionEventListener(this);
        this.resource_ = resource;
    }

    protected ExternalXAPooledConnectionImp(XAConnection c, TransactionalResource resource, PrintWriter logWriter) {
        this(c, resource);
        this.logWriter_ = logWriter;
    }

    public TransactionalResource getTransactionalResource() {
        return this.resource_;
    }

    public void setResourceTransaction(ResourceTransaction restx) throws SQLException {
        if (!(restx instanceof XAResourceTransaction)) {
            throw new RuntimeException("Expected: XAResourceTransaction");
        }
        this.restx_ = (XAResourceTransaction)restx;
        XAResource xares = this.myConn_.getXAResource();
        if (this.logWriter_ != null) {
            xares = new LoggingXAResource(xares, this.logWriter_);
        }
        this.restx_.setXAResource(xares);
        if (this.msg_ != null) {
            this.restx_.addHeuristicMessage(this.msg_);
            this.msg_ = null;
        }
    }

    public ResourceTransaction unsetResourceTransaction() {
        XAResourceTransaction ret = this.restx_;
        this.restx_ = null;
        return ret;
    }

    public Connection getConnection() throws SQLException {
        return this.getConnection(null);
    }

    public void setInvalidated() {
        this.invalidated_ = true;
    }

    public boolean getInvalidated() {
        return this.invalidated_;
    }

    public void close() throws SQLException {
        this.myConn_.removeConnectionEventListener(this);
        this.myConn_.close();
    }

    public synchronized void addConnectionEventListener(ConnectionEventListener l) {
        if (!this.listeners_.contains(l)) {
            this.listeners_.addElement(l);
        }
    }

    public synchronized void removeConnectionEventListener(ConnectionEventListener l) {
        this.listeners_.removeElement(l);
    }

    public void setLastUse(Date date) {
        this.lastUse_ = date;
    }

    public Date getLastUse() {
        return this.lastUse_;
    }

    public boolean isDiscarded() {
        return this.discarded_;
    }

    protected void setDiscarded() {
        this.discarded_ = true;
        this.connectionProxy_ = null;
        this.unsetResourceTransaction();
    }

    public void connectionClosed(ConnectionEvent e) {
        ResourceTransaction restx = this.unsetResourceTransaction();
        ExternalXAPooledConnectionImp.suspendResourceTransaction(restx);
        this.setDiscarded();
        ConnectionEvent e2 = new ConnectionEvent(this);
        Enumeration enumm = this.listeners_.elements();
        while (enumm.hasMoreElements()) {
            ConnectionEventListener l = (ConnectionEventListener)enumm.nextElement();
            l.connectionClosed(e2);
        }
    }

    public void connectionErrorOccurred(ConnectionEvent e) {
        ResourceTransaction restx = this.unsetResourceTransaction();
        ExternalXAPooledConnectionImp.suspendResourceTransaction(restx);
        this.setInvalidated();
        ConnectionEvent e2 = new ConnectionEvent(this, e.getSQLException());
        Enumeration enumm = this.listeners_.elements();
        while (enumm.hasMoreElements()) {
            ConnectionEventListener l = (ConnectionEventListener)enumm.nextElement();
            l.connectionErrorOccurred(e2);
        }
    }

    public Connection getConnection(HeuristicMessage msg) throws SQLException {
        this.msg_ = msg;
        this.discarded_ = false;
        if (this.connectionProxy_ == null) {
            this.connectionProxy_ = (Connection)ConnectionProxy.newInstance(this, this.myConn_.getConnection(), this.resource_);
        }
        return this.connectionProxy_;
    }

    public boolean isInResourceTransaction() {
        return this.restx_ != null;
    }
}

