/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.jdbc;

import com.atomikos.datasource.ResourceTransaction;
import com.atomikos.datasource.TransactionalResource;
import com.atomikos.icatch.CompositeTransaction;
import com.atomikos.icatch.Synchronization;
import com.atomikos.icatch.TxState;
import com.atomikos.icatch.system.Configuration;
import com.atomikos.jdbc.AtomikosSQLException;
import com.atomikos.jdbc.ExternalXAPooledConnectionImp;
import java.io.PrintWriter;
import java.sql.SQLException;
import java.util.Enumeration;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.XAConnection;

public class ExclusiveExternalXAPooledConnectionImp
extends ExternalXAPooledConnectionImp
implements Synchronization {
    private boolean afterCompletionDone_ = false;

    public ExclusiveExternalXAPooledConnectionImp(XAConnection c, TransactionalResource res) {
        super(c, res);
    }

    public ExclusiveExternalXAPooledConnectionImp(XAConnection c, TransactionalResource res, PrintWriter logWriter) {
        super(c, res, logWriter);
    }

    public synchronized void setResourceTransaction(ResourceTransaction restx) throws SQLException {
        super.setResourceTransaction(restx);
        try {
            CompositeTransaction ct = Configuration.getCompositeTransactionManager().getCompositeTransaction();
            ct.registerSynchronization((Synchronization)this);
            this.afterCompletionDone_ = false;
        }
        catch (Exception e) {
            AtomikosSQLException.throwAtomikosSQLException((String)e.getMessage(), (Throwable)e);
        }
    }

    public void beforeCompletion() {
        this.afterCompletionDone_ = false;
    }

    public void afterCompletion(Object state) {
        if (this.afterCompletionDone_) {
            return;
        }
        if (state.equals(TxState.TERMINATED) || state.equals(TxState.HEUR_MIXED) || state.equals(TxState.HEUR_HAZARD) || state.equals(TxState.HEUR_ABORTED) || state.equals(TxState.HEUR_COMMITTED)) {
            this.setDiscarded();
            ConnectionEvent e2 = new ConnectionEvent(this);
            Enumeration enumm = this.listeners_.elements();
            while (enumm.hasMoreElements()) {
                ConnectionEventListener l = (ConnectionEventListener)enumm.nextElement();
                l.connectionClosed(e2);
            }
            this.afterCompletionDone_ = true;
        }
    }

    public void connectionClosed(ConnectionEvent e) {
        ResourceTransaction restx = this.unsetResourceTransaction();
        if (restx != null) {
            ExclusiveExternalXAPooledConnectionImp.suspendResourceTransaction(restx);
        } else {
            this.setDiscarded();
            ConnectionEvent e2 = new ConnectionEvent(this);
            Enumeration enumm = this.listeners_.elements();
            while (enumm.hasMoreElements()) {
                ConnectionEventListener l = (ConnectionEventListener)enumm.nextElement();
                l.connectionClosed(e2);
            }
        }
    }
}

