/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.jdbc;

import com.atomikos.jdbc.ConnectionFactory;
import com.atomikos.jdbc.XPooledConnection;
import com.atomikos.logging.Logger;
import com.atomikos.logging.LoggerFactory;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;
import javax.sql.PooledConnection;

public class ConnectionPool
implements Runnable {
    private static final Logger LOGGER = LoggerFactory.createLogger(ConnectionPool.class);
    private long timeout_;
    private Vector pool_;
    private int maxSize_;
    private ConnectionFactory source_;
    private boolean timerNeeded_ = true;
    private String testQuery_;
    private boolean testOnBorrow_;

    public ConnectionPool(int size, ConnectionFactory connSource, int connectionTimeout, String testQuery, boolean testOnBorrow) throws SQLException {
        this.testQuery_ = testQuery;
        this.timeout_ = connectionTimeout * 1000;
        this.source_ = connSource;
        this.pool_ = new Vector();
        this.maxSize_ = size;
        this.testOnBorrow_ = testOnBorrow;
        for (int i = 0; i < this.maxSize_; ++i) {
            XPooledConnection pc = this.source_.getPooledConnection();
            if (pc == null) {
                throw new SQLException("ConnectionPool constructor: null PooledConnection");
            }
            this.pool_.addElement(pc);
        }
        Thread timer = new Thread(this);
        timer.setDaemon(true);
        timer.start();
    }

    public int getSize() {
        return this.pool_.size();
    }

    public synchronized PooledConnection getPooledConnection() throws SQLException {
        PooledConnection retVal;
        if (this.pool_.isEmpty()) {
            retVal = this.source_.getPooledConnection();
            LOGGER.logWarning("JDBC ConnectionPool exhausted - allocated new connection: " + ((Object)retVal).toString());
            if (this.testOnBorrow_) {
                this.test(retVal, false);
            }
        } else {
            retVal = (XPooledConnection)this.pool_.firstElement();
            if (!this.pool_.removeElement(retVal)) {
                throw new SQLException("Unable to take connection out of pool?");
            }
            if (this.testOnBorrow_) {
                try {
                    this.test(retVal, false);
                }
                catch (SQLException retry) {
                    retVal = this.getPooledConnection();
                }
            }
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.logDebug("JDBC ConnectionPool: using connection: " + retVal);
        }
        return retVal;
    }

    protected synchronized void putInPool(PooledConnection pc) {
        this.pool_.addElement(pc);
        this.notifyAll();
    }

    public synchronized void putBack(XPooledConnection conn) {
        if (!conn.getInvalidated() && this.getSize() < this.maxSize_) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.logDebug("Putting connection back in pool: " + ((Object)conn).toString());
            }
            this.putInPool(conn);
        } else {
            try {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.logDebug("Pool: closing connection: " + ((Object)conn).toString());
                }
                conn.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    protected synchronized Enumeration getOldConnections() {
        Vector<XPooledConnection> returnVals = new Vector<XPooledConnection>();
        Date now = new Date();
        Enumeration enumm = this.pool_.elements();
        while (enumm.hasMoreElements()) {
            XPooledConnection pc = (XPooledConnection)enumm.nextElement();
            if (now.getTime() - pc.getLastUse().getTime() <= this.timeout_) continue;
            returnVals.addElement(pc);
        }
        enumm = returnVals.elements();
        while (enumm.hasMoreElements()) {
            this.pool_.removeElement(enumm.nextElement());
        }
        return returnVals.elements();
    }

    public void run() {
        try {
            while (this.timerNeeded_) {
                Thread.sleep(this.timeout_);
                Enumeration enumm = this.getOldConnections();
                while (this.timerNeeded_ && enumm.hasMoreElements()) {
                    XPooledConnection pc = (XPooledConnection)enumm.nextElement();
                    try {
                        if (!pc.getInvalidated()) {
                            this.test(pc, true);
                            if (LOGGER.isDebugEnabled()) {
                                LOGGER.logDebug("ConnectionPool: connection is fine, keeping it in pool: " + pc);
                            }
                            this.putInPool(pc);
                            continue;
                        }
                        if (this.getSize() >= this.maxSize_) continue;
                        XPooledConnection newConn = this.source_.getPooledConnection();
                        this.putInPool(newConn);
                        LOGGER.logDebug("ConnectionPool: replacing invalidated connection " + ((Object)pc).toString());
                    }
                    catch (SQLException sqlErr) {
                        if (this.getSize() >= this.maxSize_) continue;
                        XPooledConnection newConn = this.source_.getPooledConnection();
                        this.putInPool(newConn);
                        LOGGER.logDebug("ConnectionPool: connection invalid, replacing it: " + ((Object)pc).toString(), (Throwable)sqlErr);
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void test(PooledConnection pc, boolean closeConnectionAfterTest) throws SQLException {
        Connection connection = null;
        boolean cleanup = false;
        try {
            connection = pc.getConnection();
            if (this.testQuery_ == null || "".equals(this.testQuery_)) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.logDebug("ConnectionPool: no query to test connection, trying getMetaData(): " + connection);
                }
                connection.getMetaData();
                return;
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.logDebug("ConnectionPool: trying query '" + this.testQuery_ + "' on connection " + connection);
            }
            Statement stmt = connection.createStatement();
            ResultSet rs = stmt.executeQuery(this.testQuery_);
            rs.close();
            stmt.close();
        }
        catch (Exception e) {
            LOGGER.logWarning("ConnectionPool: error testing connection", (Throwable)e);
            cleanup = true;
            SQLException sqlErr = new SQLException(e.getMessage());
            sqlErr.initCause(e);
            throw sqlErr;
        }
        finally {
            try {
                if (connection != null && (closeConnectionAfterTest || cleanup)) {
                    connection.close();
                }
                if (cleanup) {
                    pc.close();
                }
            }
            catch (SQLException error) {
                LOGGER.logWarning("ConnectionPool: error closing connection during test", (Throwable)error);
            }
        }
    }

    public synchronized void cleanup() {
        this.timerNeeded_ = false;
        if (this.pool_ == null) {
            return;
        }
        Enumeration enumm = this.pool_.elements();
        try {
            while (enumm.hasMoreElements()) {
                PooledConnection pc = (PooledConnection)enumm.nextElement();
                pc.close();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        this.pool_ = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finalize() throws Throwable {
        try {
            this.cleanup();
        }
        finally {
            super.finalize();
        }
    }

    public PrintWriter getLogWriter() throws SQLException {
        return this.source_.getLogWriter();
    }

    public void setLogWriter(PrintWriter pw) throws SQLException {
        this.source_.setLogWriter(pw);
    }

    public void setLoginTimeout(int secs) throws SQLException {
        this.source_.setLoginTimeout(secs);
    }

    public int getLoginTimeout() throws SQLException {
        return this.source_.getLoginTimeout();
    }
}

