/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.timing;

import com.atomikos.timing.AlarmTimer;
import com.atomikos.timing.AlarmTimerListener;
import java.util.ArrayList;
import java.util.List;

public final class PooledAlarmTimer
implements AlarmTimer {
    private final List<AlarmTimerListener> listeners;
    private final long timeout;
    private final Object runMonitor = new Object();
    private boolean runFlag = true;

    public PooledAlarmTimer(long timeout) {
        this.listeners = new ArrayList<AlarmTimerListener>();
        this.timeout = timeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addAlarmTimerListener(AlarmTimerListener lstnr) {
        List<AlarmTimerListener> list = this.listeners;
        synchronized (list) {
            this.listeners.add(lstnr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeAlarmTimerListener(AlarmTimerListener lstnr) {
        List<AlarmTimerListener> list = this.listeners;
        synchronized (list) {
            this.listeners.remove(lstnr);
        }
    }

    @Override
    public long getTimeout() {
        return this.timeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isActive() {
        Object object = this.runMonitor;
        synchronized (object) {
            return this.runFlag;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        Object object = this.runMonitor;
        synchronized (object) {
            this.runFlag = false;
            this.runMonitor.notify();
        }
    }

    @Override
    public void run() {
        while (this.isActive()) {
            try {
                this.doWait(this.timeout);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (!this.isActive()) continue;
            this.notifyListeners();
        }
    }

    private void notifyListeners() {
        ArrayList<AlarmTimerListener> tempList = new ArrayList<AlarmTimerListener>(this.listeners);
        for (AlarmTimerListener list : tempList) {
            list.alarm(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doWait(long millis) throws InterruptedException {
        Object object = this.runMonitor;
        synchronized (object) {
            this.runMonitor.wait(millis);
        }
    }
}

