/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.publish;

import com.atomikos.icatch.event.Event;
import com.atomikos.icatch.event.EventListener;
import com.atomikos.logging.Logger;
import com.atomikos.logging.LoggerFactory;
import java.util.HashSet;
import java.util.ServiceLoader;
import java.util.Set;

public class EventPublisher {
    private static Logger LOGGER = LoggerFactory.createLogger(EventPublisher.class);
    private static Set<EventListener> listeners = new HashSet<EventListener>();

    private EventPublisher() {
    }

    private static void findAllEventListenersInClassPath() {
        ServiceLoader<EventListener> loader = ServiceLoader.load(EventListener.class, EventPublisher.class.getClassLoader());
        for (EventListener l : loader) {
            EventPublisher.registerEventListener(l);
        }
    }

    public static void publish(Event event) {
        if (event != null) {
            EventPublisher.notifyAllListeners(event);
        }
    }

    private static void notifyAllListeners(Event event) {
        for (EventListener listener : listeners) {
            try {
                listener.eventOccurred(event);
            }
            catch (Exception e) {
                LOGGER.logError("Error notifying listener " + listener, e);
            }
        }
    }

    public static void registerEventListener(EventListener listener) {
        listeners.add(listener);
    }

    static {
        EventPublisher.findAllEventListenersInClassPath();
    }
}

