/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.diagnostics;

import com.atomikos.diagnostics.Console;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.FileHandler;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public class RotatingFileConsole
implements Console {
    private static final Object eolIndicatorParameter = new Object();
    private int level = 1;
    private Logger logger;
    private FileHandler handler;

    public RotatingFileConsole(String fileNamePattern, int limit, int fileCount) throws SecurityException, IOException {
        this.setLevel(1);
        this.handler = limit >= 0 ? new FileHandler(fileNamePattern, limit, fileCount, true) : new FileHandler(fileNamePattern, true);
        this.logger = Logger.getLogger("com.atomikos.diagnostics");
        this.logger.addHandler(this.handler);
        this.logger.setLevel(Level.ALL);
        this.logger.setUseParentHandlers(false);
        this.handler.setFormatter(new FileFormatter());
    }

    public void println(String string) throws IOException {
        this.logger.log(Level.WARNING, string, eolIndicatorParameter);
    }

    public void print(String string) throws IOException {
        Object dummy = null;
        this.logger.log(Level.WARNING, string, (Object)dummy);
    }

    public void println(String string, int level) throws IOException {
        if (this.getLevel() >= level) {
            this.println(string);
        }
    }

    public void print(String string, int level) throws IOException {
        if (this.getLevel() >= level) {
            this.print(string);
        }
    }

    public void close() throws IOException {
        this.handler.close();
    }

    public void setLevel(int level) {
        this.level = level;
    }

    public int getLevel() {
        return this.level;
    }

    private static class FileFormatter
    extends Formatter {
        private DateFormat formatter = new SimpleDateFormat("yy-MM-dd kk:mm:ss,SSS");

        FileFormatter() {
        }

        public String format(LogRecord record) {
            StringBuffer buf = new StringBuffer();
            Object[] pars = record.getParameters();
            if (pars[0] != null) {
                buf.append(this.formatter.format(new Date()));
                buf.append(" [" + Thread.currentThread().getName() + "] ");
            }
            buf.append(record.getMessage());
            buf.append("\n");
            return buf.toString();
        }
    }
}

