/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.util;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.Date;

public class UniqueIdMgr
implements Serializable {
    private static long MAX_PER_EPOCH = 32000L;
    String server_;
    long epoch_;
    long lastcounter_;
    String filename_ = null;
    int limit_;
    private String prefix_;
    private String suffix_;

    public UniqueIdMgr(String string) {
        this(string, "./");
        this.limit_ = -1;
        this.server_ = string;
        this.epoch_ = new Date().getDate();
        this.lastcounter_ = 0L;
    }

    public UniqueIdMgr(String string, String string2) {
        this(string, string2, -1);
    }

    public UniqueIdMgr(String string, String string2, int n) {
        this.limit_ = n;
        this.server_ = string;
        this.filename_ = string2 + string + ".epoch";
        this.setSuffix("");
        this.setPrefix("");
        try {
            this.epoch_ = this.readEpoch();
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.getMessage());
        }
        this.lastcounter_ = 0L;
    }

    public void setSuffix(String string) {
        this.suffix_ = string;
    }

    public void setPrefix(String string) {
        this.prefix_ = string;
    }

    protected long readEpoch() throws IOException {
        long l = 0L;
        File file = new File(this.filename_);
        if (!file.exists()) {
            l = 0L;
        } else {
            FileInputStream fileInputStream = new FileInputStream(file);
            DataInputStream dataInputStream = new DataInputStream(fileInputStream);
            l = dataInputStream.readLong();
            dataInputStream.close();
            fileInputStream.close();
        }
        this.writeEpoch(l + 1L);
        if (l + 1L <= 0L) {
            throw new RuntimeException("Epoch overflow!");
        }
        return l + 1L;
    }

    protected void writeEpoch(long l) throws IOException {
        if (l <= 0L || this.limit_ >= 0 && l > (long)this.limit_) {
            throw new RuntimeException("Epoch overflow!");
        }
        FileOutputStream fileOutputStream = new FileOutputStream(this.filename_);
        DataOutputStream dataOutputStream = new DataOutputStream(fileOutputStream);
        dataOutputStream.writeLong(l);
        dataOutputStream.close();
        fileOutputStream.close();
    }

    private String getCountWithLeadingZeroes(long l) {
        String string = Long.toString(l);
        int n = Long.toString(MAX_PER_EPOCH).length();
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = string.length(); i < n; ++i) {
            stringBuffer.append("0");
        }
        string = stringBuffer.append(string).toString();
        return string;
    }

    public synchronized String get() {
        ++this.lastcounter_;
        if (this.lastcounter_ > MAX_PER_EPOCH) {
            this.lastcounter_ = 0L;
            ++this.epoch_;
            try {
                this.writeEpoch(this.epoch_);
            }
            catch (Exception exception) {
                throw new RuntimeException(exception.getMessage());
            }
        }
        return this.prefix_ + this.server_ + this.suffix_ + this.getCountWithLeadingZeroes(this.lastcounter_) + this.getCountWithLeadingZeroes(this.epoch_);
    }
}

