/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.util;

import com.atomikos.util.Identifiable;
import com.atomikos.util.ObjectNotFoundException;
import com.atomikos.util.ObjectPool;
import com.atomikos.util.PooledObject;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public abstract class BaseObjectPool
implements ObjectPool {
    protected Hashtable pool_ = null;
    protected long size_ = 0L;
    protected long maxSize_ = 5L;

    public BaseObjectPool(long l) {
        if (l > 0L) {
            this.maxSize_ = l;
        }
        this.pool_ = new Hashtable();
    }

    public long getSize() {
        return this.size_;
    }

    public long getMaxSize() {
        return this.maxSize_;
    }

    public boolean isFull() {
        return this.size_ == this.maxSize_;
    }

    public boolean isEmpty() {
        return this.size_ == 0L;
    }

    public Identifiable add(Identifiable identifiable) {
        Object object;
        Identifiable identifiable2 = null;
        if (this.size_ == this.maxSize_) {
            object = this.getVictim();
            try {
                identifiable2 = this.remove(object);
            }
            catch (ObjectNotFoundException objectNotFoundException) {
                throw new RuntimeException(objectNotFoundException.getMessage());
            }
        }
        object = this.wrap(identifiable);
        this.pool_.put(identifiable.getId(), object);
        ++this.size_;
        return identifiable2;
    }

    public Identifiable retrieve(Object object) throws ObjectNotFoundException {
        PooledObject pooledObject = null;
        if (!this.pool_.containsKey(object)) {
            throw new ObjectNotFoundException(object.toString());
        }
        pooledObject = (PooledObject)this.pool_.get(object);
        pooledObject.selected();
        return pooledObject.getObject();
    }

    public Identifiable retrieve() throws ObjectNotFoundException {
        Object object = this.getVictim();
        return this.retrieve(this.getVictim());
    }

    public Identifiable remove() throws ObjectNotFoundException {
        Object object = this.getVictim();
        return this.remove(object);
    }

    public Identifiable remove(Object object) throws ObjectNotFoundException {
        if (!this.pool_.containsKey(object)) {
            throw new ObjectNotFoundException(object.toString());
        }
        --this.size_;
        return ((PooledObject)this.pool_.remove(object)).getObject();
    }

    public Enumeration elements() throws ObjectNotFoundException {
        Vector<Identifiable> vector = new Vector<Identifiable>();
        if (this.pool_.isEmpty()) {
            throw new ObjectNotFoundException();
        }
        Enumeration enumeration = this.pool_.elements();
        while (enumeration.hasMoreElements()) {
            PooledObject pooledObject = (PooledObject)enumeration.nextElement();
            Identifiable identifiable = pooledObject.getObject();
            vector.addElement(identifiable);
        }
        return vector.elements();
    }

    protected Enumeration internalElements() {
        return this.pool_.elements();
    }

    protected abstract Object getVictim();

    protected abstract PooledObject wrap(Identifiable var1);
}

