/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.beans;

import com.atomikos.beans.BeanInspector;
import com.atomikos.beans.Editor;
import com.atomikos.beans.Property;
import com.atomikos.beans.PropertyException;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.ArrayList;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class BeanWizard
implements PropertyChangeListener {
    private JPanel panel_ = new JPanel();
    private BeanInspector inspector_;

    private static Property[] filterProperties(Property[] propertyArray) throws PropertyException {
        if (propertyArray == null) {
            return null;
        }
        ArrayList<Property> arrayList = new ArrayList<Property>();
        for (int i = 0; i < propertyArray.length; ++i) {
            if (propertyArray[i].isHidden() || propertyArray[i].isReadOnly() || propertyArray[i].getEditor() == null) continue;
            arrayList.add(propertyArray[i]);
        }
        return arrayList.toArray(new Property[0]);
    }

    public BeanWizard(Object object) throws PropertyException {
        this.panel_.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        this.inspector_ = new BeanInspector(object);
        Property[] propertyArray = BeanWizard.filterProperties(this.inspector_.getProperties());
        int n = 0;
        if (propertyArray != null) {
            n = propertyArray.length;
        }
        jPanel.setLayout(new GridLayout(n, 1));
        for (int i = 0; i < n; ++i) {
            Serializable serializable;
            JPanel jPanel2 = new JPanel();
            jPanel2.setLayout(new GridLayout(1, 2));
            JLabel jLabel = new JLabel(propertyArray[i].getName());
            if (propertyArray[i].isPreferred()) {
                serializable = new Font("SansSerif", 1, 12);
                jLabel.setFont((Font)serializable);
            } else {
                serializable = new Font("SansSerif", 0, 12);
                jLabel.setFont((Font)serializable);
            }
            jPanel2.add(jLabel);
            if (propertyArray[i].getIndexedProperty() != null) {
                serializable = new JButton("Edit");
                ((AbstractButton)serializable).addActionListener(new ButtonListener(propertyArray[i]));
                jPanel2.add((Component)serializable);
            } else {
                jPanel2.add(propertyArray[i].getEditor().getComponent());
            }
            propertyArray[i].getEditor().addPropertyChangeListener(this);
            jPanel.add(jPanel2);
            this.panel_.setPreferredSize(new Dimension(300, 300));
            this.panel_.add((Component)new JScrollPane(jPanel), "Center");
        }
    }

    public JPanel getPanel() {
        return this.panel_;
    }

    public Object getBean() {
        if (this.inspector_ == null) {
            return null;
        }
        return this.inspector_.getBean();
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        Editor editor = (Editor)propertyChangeEvent.getSource();
        Property property = editor.getProperty();
        System.err.println("BeanWizard: propertyChange");
        try {
            System.err.println(editor.getEditedObject().getClass().getName());
            property.setValue(editor.getEditedObject());
            System.err.println("Property set: " + property.getName());
            System.err.println("to value: " + editor.getEditedObject());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    static class ButtonListener
    implements ActionListener {
        private Property property_;

        ButtonListener(Property property) {
            this.property_ = property;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                JOptionPane.showMessageDialog(null, this.property_.getEditor().getComponent(), "Edit", -1);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }
}

