/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webhooks.internal.rest.history;

import com.atlassian.webhooks.history.InvocationRequest;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Nonnull;

public class RestInvocationRequest
extends LinkedHashMap<String, Object> {
    public static RestInvocationRequest EXAMPLE = new RestInvocationRequest("POST", "http://example.com/callback");
    private static final String METHOD = "method";
    private static final String URL = "url";

    public RestInvocationRequest() {
    }

    public RestInvocationRequest(@Nonnull InvocationRequest request) {
        this.put(METHOD, request.getMethod());
        this.put(URL, request.getUrl());
    }

    public RestInvocationRequest(String method, String url) {
        this.put(METHOD, method);
        this.put(URL, url);
    }

    public static RestInvocationRequest valueOf(Object value) {
        if (value instanceof RestInvocationRequest) {
            return (RestInvocationRequest)value;
        }
        if (value instanceof InvocationRequest) {
            return new RestInvocationRequest((InvocationRequest)value);
        }
        if (value instanceof Map) {
            Map map = (Map)value;
            return new RestInvocationRequest((String)map.get(METHOD), (String)map.get(URL));
        }
        return null;
    }
}

