/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webhooks.internal.rest;

import com.atlassian.webhooks.request.WebhookHttpResponse;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.io.IOUtils;

@JsonSerialize
public class RestWebhookResponse
extends LinkedHashMap<String, Object> {
    public static RestWebhookResponse EXAMPLE = new RestWebhookResponse(200, (Map<String, String>)ImmutableMap.of((Object)"Content-Type", (Object)"application/json"), "{\n  \"accepted\": true\n}");
    private final String BODY = "body";
    private final String HEADERS = "headers";
    private final String STATUS = "status";

    public RestWebhookResponse() {
    }

    public RestWebhookResponse(WebhookHttpResponse response) {
        this.put("status", response.getStatusCode());
        this.put("headers", response.getHeaders().getHeaders());
        try {
            this.put("body", IOUtils.toString((InputStream)response.getBody().getContent(), (String)StandardCharsets.UTF_8.toString()));
        }
        catch (IOException ex) {
            this.put("body", "Unable to set body");
        }
    }

    private RestWebhookResponse(int status, Map<String, String> headers, String body) {
        this.put("status", status);
        this.put("headers", headers);
        this.put("body", body);
    }
}

