package com.atlassian.velocity.htmlsafe.context;

import com.atlassian.velocity.htmlsafe.util.Check;
import org.apache.velocity.app.event.EventCartridge;

/**
 * Aggregates a set of {@link EventCartridgeProcessor}s.
 */
public final class EventCartridgeProcessingChain implements EventCartridgeProcessor {
    private final EventCartridgeProcessor[] processors;

    public EventCartridgeProcessingChain(EventCartridgeProcessor... processors) {
        Check.notNull(processors, "processors must not be null");
        this.processors = processors.clone();
    }

    public void processCartridge(EventCartridge cartridge) {
        for (EventCartridgeProcessor processor : processors) {
            processor.processCartridge(cartridge);
        }
    }
}
