/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.utils.process;

import com.atlassian.utils.process.ProcessHandler;
import com.atlassian.utils.process.ProcessMonitor;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExternalProcessSettings {
    private final Map<String, String> environment = new HashMap<String, String>();
    private final List<ProcessMonitor> monitors = new ArrayList<ProcessMonitor>();
    private List<String> command;
    private long executionTimeout;
    private long idleTimeout;
    private ProcessHandler processHandler;
    private boolean suppressSpecialWindowsBehaviour;
    private boolean useWindowsEncodingWorkaround;
    private File workingDirectory;

    public Map<String, String> getEnvironment() {
        return this.environment;
    }

    public List<ProcessMonitor> getMonitors() {
        return this.monitors;
    }

    public List<String> getCommand() {
        return this.command;
    }

    public long getExecutionTimeout() {
        return this.executionTimeout;
    }

    public long getIdleTimeout() {
        return this.idleTimeout;
    }

    public ProcessHandler getProcessHandler() {
        return this.processHandler;
    }

    public File getWorkingDirectory() {
        return this.workingDirectory;
    }

    public boolean hasEnvironment() {
        return !this.environment.isEmpty();
    }

    public boolean hasExecutionTimeout() {
        return this.executionTimeout > 0L;
    }

    public boolean hasIdleTimeout() {
        return this.idleTimeout > 0L;
    }

    public boolean isSuppressSpecialWindowsBehaviour() {
        return this.suppressSpecialWindowsBehaviour;
    }

    public boolean isUseWindowsEncodingWorkaround() {
        return this.useWindowsEncodingWorkaround;
    }

    public void setCommand(List<String> command) {
        this.command = command;
    }

    public void setExecutionTimeout(long executionTimeout) {
        this.executionTimeout = executionTimeout;
    }

    public void setIdleTimeout(long idleTimeout) {
        this.idleTimeout = idleTimeout;
    }

    public void setProcessHandler(ProcessHandler processHandler) {
        this.processHandler = processHandler;
    }

    public void setSuppressSpecialWindowsBehaviour(boolean suppressSpecialWindowsBehaviour) {
        this.suppressSpecialWindowsBehaviour = suppressSpecialWindowsBehaviour;
    }

    public void setUseWindowsEncodingWorkaround(boolean useWindowsEncodingWorkaround) {
        this.useWindowsEncodingWorkaround = useWindowsEncodingWorkaround;
    }

    public void setWorkingDirectory(File workingDirectory) {
        this.workingDirectory = workingDirectory;
    }

    public void validate() {
        if (this.command == null || this.command.isEmpty()) {
            throw new IllegalStateException("A command is required");
        }
        if (this.processHandler == null) {
            throw new IllegalStateException("A ProcessHandler is required");
        }
    }
}

