/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.utils.process;

import com.atlassian.utils.process.ExternalProcess;
import com.atlassian.utils.process.LatchedRunnable;
import com.atlassian.utils.process.ProcessException;
import com.atlassian.utils.process.ProcessHandler;
import com.atlassian.utils.process.ProcessMonitor;
import com.atlassian.utils.process.ProcessTimeoutException;
import com.atlassian.utils.process.ProcessUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;
import org.jvnet.winp.WinProcess;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExternalProcessImpl
implements ExternalProcess {
    private static final Logger LOG = Logger.getLogger(ExternalProcessImpl.class);
    private static final String OS_NAME = System.getProperty("os.name").toLowerCase();
    private static final ExecutorService POOL;
    private boolean canceled;
    private List<String> command;
    private Map<String, String> environment;
    private LatchedRunnable errorPump;
    private long executionTimeout;
    private ProcessHandler handler;
    private long idleTimeout;
    private LatchedRunnable inputPump;
    private long lastWatchdogReset;
    private List<ProcessMonitor> monitors;
    private LatchedRunnable outputPump;
    private Process process;
    private ProcessException processException;
    private boolean suppressSpecialWindowsBehaviour;
    private long startTime;
    private File workingDir;
    private boolean useWindowsEncodingWorkaround;

    public ExternalProcessImpl(String[] command, ProcessHandler handler) {
        this(Arrays.asList(command), handler);
    }

    public ExternalProcessImpl(List<String> command, ProcessHandler handler) {
        this.setCommand(command);
        this.setHandler(handler);
        this.idleTimeout = TimeUnit.MINUTES.toMillis(1L);
        this.monitors = new ArrayList<ProcessMonitor>();
        this.startTime = -1L;
    }

    public ExternalProcessImpl(String commandLine, ProcessHandler handler) {
        this(ProcessUtils.tokenizeCommand(commandLine), handler);
    }

    @Override
    public void resetWatchdog() {
        this.lastWatchdogReset = System.currentTimeMillis();
    }

    public long getTimeoutTime() {
        long timeout = this.lastWatchdogReset + this.idleTimeout;
        if (this.executionTimeout > 0L && this.startTime > 0L) {
            timeout = Math.min(timeout, this.startTime + this.executionTimeout);
        }
        return timeout;
    }

    public boolean isTimedOut() {
        return this.getTimeoutTime() < System.currentTimeMillis();
    }

    protected void setHandler(ProcessHandler handler) {
        this.handler = handler;
    }

    private void setCommand(List<String> command) {
        this.command = command;
    }

    public void setWorkingDir(File workingDir) {
        this.workingDir = workingDir;
    }

    public void setEnvironment(Map<String, String> environment) {
        this.environment = environment;
    }

    public void setSuppressSpecialWindowsBehaviour(boolean suppressSpecialWindowsBehaviour) {
        this.suppressSpecialWindowsBehaviour = suppressSpecialWindowsBehaviour;
    }

    public void setUseWindowsEncodingWorkaround(boolean useWindowsEncodingWorkaround) {
        this.useWindowsEncodingWorkaround = useWindowsEncodingWorkaround;
    }

    private boolean arePumpsRunning() {
        return this.outputPump.isRunning() || this.errorPump.isRunning() || this.inputPump != null && this.inputPump.isRunning();
    }

    @Override
    public ProcessHandler getHandler() {
        return this.handler;
    }

    @Override
    public long getStartTime() {
        return this.startTime;
    }

    public void addMonitor(ProcessMonitor monitor) {
        this.monitors.add(monitor);
    }

    public void removeMonitor(ProcessMonitor monitor) {
        this.monitors.remove(monitor);
    }

    private boolean isWindows() {
        return OS_NAME.contains("windows");
    }

    private String quoteString(String value) {
        StringBuilder builder = new StringBuilder().append("\"").append(value.replace("\"", "\\\"")).append("\"");
        return builder.toString();
    }

    private Process createWinProcess(List<String> command, Map<String, String> environment, File workingDir) throws IOException {
        ArrayList<String> newCommand = new ArrayList<String>(command.size() + 3);
        newCommand.add("cmd");
        newCommand.add("/A");
        newCommand.add("/C");
        if (this.useWindowsEncodingWorkaround) {
            newCommand.add(command.get(0));
            HashMap<String, String> i18nEnvironment = environment == null ? new HashMap<String, String>() : new HashMap<String, String>(environment);
            for (int counter = 1; counter < command.size(); ++counter) {
                String envName = "JENV_" + counter;
                newCommand.add("%" + envName + "%");
                i18nEnvironment.put(envName, this.quoteString(command.get(counter)));
            }
            environment = i18nEnvironment;
        } else {
            newCommand.addAll(command);
        }
        ProcessBuilder builder = new ProcessBuilder(newCommand).directory(workingDir);
        if (environment != null) {
            builder.environment().putAll(environment);
        }
        if (LOG.isDebugEnabled()) {
            this.logProcessDetails(builder);
        }
        return builder.start();
    }

    protected Process createProcess(List<String> command, Map<String, String> environment, File workingDir) throws IOException {
        if (!this.suppressSpecialWindowsBehaviour && this.isWindows()) {
            return this.createWinProcess(command, environment, workingDir);
        }
        ProcessBuilder builder = new ProcessBuilder(command).directory(workingDir);
        if (environment != null) {
            builder.environment().putAll(environment);
        }
        if (LOG.isDebugEnabled()) {
            this.logProcessDetails(builder);
        }
        return builder.start();
    }

    private void logProcessDetails(ProcessBuilder processBuilder) {
        String divider = "---------------------------";
        LOG.debug((Object)divider);
        LOG.debug((Object)"Start Process Debug Information");
        LOG.debug((Object)divider);
        LOG.debug((Object)"Command");
        LOG.debug(processBuilder.command());
        LOG.debug((Object)divider);
        LOG.debug((Object)"Working Dir");
        LOG.debug((Object)processBuilder.directory());
        LOG.debug((Object)divider);
        LOG.debug((Object)"Environment");
        for (Map.Entry<String, String> entry : processBuilder.environment().entrySet()) {
            LOG.debug((Object)(entry.getKey() + ": " + entry.getValue()));
        }
        LOG.debug((Object)divider);
        LOG.debug((Object)"Redirect Error Stream?");
        LOG.debug((Object)processBuilder.redirectErrorStream());
        LOG.debug((Object)divider);
        LOG.debug((Object)"End Process Debug Information");
        LOG.debug((Object)divider);
    }

    @Override
    public void start() {
        try {
            this.startTime = System.currentTimeMillis();
            this.process = this.createProcess(this.command, this.environment, this.workingDir);
            this.setupIOPumps();
        }
        catch (IOException e) {
            this.processException = new ProcessException(e);
        }
    }

    private void handleHandlerError(String handlerName, Throwable t) {
        if (!this.isCanceled()) {
            LOG.debug((Object)(handlerName + " encountered an error; aborting process"), t);
            this.cancel();
            this.processException = t instanceof ProcessException ? (ProcessException)t : new ProcessException(t);
        } else {
            LOG.debug((Object)(handlerName + ": Process canceled; ignoring exception"), t);
        }
    }

    private void setupIOPumps() {
        if (this.handler.hasInput()) {
            this.inputPump = new LatchedRunnable("StdInHandler " + this.process){

                protected void doTask() {
                    try {
                        ExternalProcessImpl.this.handler.provideInput(ExternalProcessImpl.this.process.getOutputStream());
                    }
                    catch (Throwable t) {
                        ExternalProcessImpl.this.handleHandlerError(this.name, t);
                    }
                }
            };
        }
        this.errorPump = new LatchedRunnable("StdErrHandler " + this.process){

            protected void doTask() {
                try {
                    ExternalProcessImpl.this.handler.processError(ExternalProcessImpl.this.process.getErrorStream());
                }
                catch (Throwable t) {
                    ExternalProcessImpl.this.handleHandlerError(this.name, t);
                }
            }
        };
        this.outputPump = new LatchedRunnable("StdOutHandler " + this.process){

            protected void doTask() {
                try {
                    ExternalProcessImpl.this.handler.processOutput(ExternalProcessImpl.this.process.getInputStream());
                }
                catch (Throwable t) {
                    ExternalProcessImpl.this.handleHandlerError(this.name, t);
                }
            }
        };
        this.resetWatchdog();
        this.handler.setWatchdog(this);
        POOL.execute(this.errorPump);
        POOL.execute(this.outputPump);
        if (this.inputPump != null) {
            POOL.execute(this.inputPump);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void finish() {
        if (this.process != null) {
            try {
                do {
                    long checkTime = this.getTimeoutTime();
                    this.awaitPump(this.outputPump, checkTime);
                    this.awaitPump(this.inputPump, checkTime);
                    this.awaitPump(this.errorPump, checkTime);
                } while (!this.isTimedOut() && this.arePumpsRunning() && !Thread.currentThread().isInterrupted());
            }
            finally {
                if (Thread.currentThread().isInterrupted()) {
                    this.cancel();
                    Thread.interrupted();
                }
                int exitCode = this.wrapUpProcess();
                this.handler.complete(exitCode, this.canceled, this.processException);
            }
        } else {
            this.handler.complete(-1, false, this.processException);
        }
    }

    private void notifyBeforeStart() {
        for (ProcessMonitor monitor : this.monitors) {
            try {
                monitor.onBeforeStart(this);
            }
            catch (Exception e) {
                LOG.error((Object)"Error while processing 'beforeStarted' event:", (Throwable)e);
            }
        }
    }

    private void notifyAfterFinished() {
        for (ProcessMonitor monitor : this.monitors) {
            try {
                monitor.onAfterFinished(this);
            }
            catch (Exception e) {
                LOG.error((Object)"Error while processing 'afterFinished' event:", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() {
        this.notifyBeforeStart();
        try {
            this.start();
            this.finish();
        }
        finally {
            this.notifyAfterFinished();
        }
    }

    @Override
    public void executeWhile(Runnable runnable) {
        this.start();
        if (runnable != null) {
            runnable.run();
        }
        this.finish();
    }

    @Override
    public String getCommandLine() {
        StringBuilder builder = new StringBuilder();
        for (String s : this.command) {
            if (builder.length() > 0) {
                builder.append(" ");
            }
            builder.append(s);
        }
        return builder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean finish(int maxWait) {
        if (this.process != null) {
            boolean finished = false;
            try {
                long endTime = System.currentTimeMillis() + (long)maxWait;
                this.awaitPump(this.outputPump, endTime);
                this.awaitPump(this.inputPump, endTime);
                this.awaitPump(this.errorPump, endTime);
            }
            finally {
                if (!this.arePumpsRunning()) {
                    finished = true;
                    int exitCode = this.wrapUpProcess();
                    this.handler.complete(exitCode, this.canceled, this.processException);
                }
            }
            return finished;
        }
        this.handler.complete(-1, false, this.processException);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int wrapUpProcess() {
        int exitCode = -1;
        boolean processIncomplete = true;
        boolean interrupted = false;
        try {
            exitCode = this.process.exitValue();
            processIncomplete = false;
        }
        catch (IllegalThreadStateException itse) {
            while (processIncomplete && System.currentTimeMillis() - this.getTimeoutTime() < 10L) {
                try {
                    Thread.sleep(100L);
                    exitCode = this.process.exitValue();
                    processIncomplete = false;
                }
                catch (InterruptedException ie) {
                    processIncomplete = true;
                    interrupted = true;
                    break;
                }
                catch (IllegalThreadStateException e) {
                }
            }
        }
        finally {
            this.internalCancel();
        }
        if (processIncomplete && !interrupted) {
            this.processException = new ProcessTimeoutException("process timed out");
        }
        return exitCode;
    }

    private void awaitPump(LatchedRunnable runnable, long latestTime) {
        if (runnable != null) {
            long timeout = latestTime - System.currentTimeMillis();
            if (timeout < 1L) {
                timeout = 1L;
            }
            runnable.await(timeout);
        }
    }

    @Override
    public void cancel() {
        this.canceled = true;
        this.internalCancel();
    }

    private void internalCancel() {
        if (this.outputPump != null) {
            this.outputPump.cancel();
        }
        if (this.inputPump != null) {
            this.inputPump.cancel();
        }
        if (this.errorPump != null) {
            this.errorPump.cancel();
        }
        if (this.process != null) {
            if (this.isWindows()) {
                try {
                    new WinProcess(this.process).killRecursively();
                }
                catch (Throwable t) {
                    LOG.error((Object)"Failed to kill Windows process; falling back on Process.destroy()", t);
                    this.process.destroy();
                }
            } else {
                this.process.destroy();
            }
        }
    }

    @Override
    public boolean isCanceled() {
        return this.canceled;
    }

    public void setExecutionTimeout(long executionTimeout) {
        this.executionTimeout = executionTimeout;
    }

    public void setIdleTimeout(long idleTimeout) {
        this.idleTimeout = idleTimeout;
    }

    @Deprecated
    public void setTimeout(long timeout) {
        this.setIdleTimeout(timeout);
    }

    public static void shutdown() {
        if (POOL == null) {
            return;
        }
        LOG.debug((Object)"Attempting to shutdown pump executor service");
        POOL.shutdown();
        try {
            if (POOL.awaitTermination(5L, TimeUnit.SECONDS)) {
                LOG.debug((Object)"Pump executor service has shutdown gracefully");
            } else {
                LOG.warn((Object)"Pump executor service did not shutdown within the timeout; forcing shutdown");
                POOL.shutdownNow();
                if (POOL.awaitTermination(5L, TimeUnit.SECONDS)) {
                    LOG.debug((Object)"Pump executor service has been forced to shutdown");
                } else {
                    LOG.warn((Object)"Pump executor service did not shutdown; it will be abandoned");
                }
            }
        }
        catch (InterruptedException e) {
            LOG.warn((Object)"Interrupted while waiting for the pump executor service to shutdown; some worker threads may still be running");
        }
    }

    static {
        String pooledThreadName = "ExtProcess IO Pump";
        ThreadFactory threadFactory = new ThreadFactory(){

            public Thread newThread(Runnable r) {
                return new Thread(r, "ExtProcess IO Pump");
            }
        };
        POOL = new ThreadPoolExecutor(6, Integer.MAX_VALUE, 2L, TimeUnit.MINUTES, (BlockingQueue)new SynchronousQueue(), threadFactory){

            protected void beforeExecute(Thread thread, Runnable runnable) {
                thread.setName(thread.getId() + ":" + ((LatchedRunnable)runnable).getName());
                super.beforeExecute(thread, runnable);
            }

            protected void afterExecute(Runnable runnable, Throwable throwable) {
                Thread.currentThread().setName("ExtProcess IO Pump");
                super.afterExecute(runnable, throwable);
            }
        };
    }
}

