package com.atlassian.utils.process;

import java.io.InputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.InterruptedIOException;

/**
 * An Output Handler which copies the process output to a give output stream
 */
public class CopyOutputHandler extends BaseOutputHandler {
    private final OutputStream dest;

    /**
     * Create a CopyOutputHandler to redirect output from the process to the given stream
     *
     * @param dest the stream to which output is to be written
     */
    public CopyOutputHandler(OutputStream dest) {
        this.dest = dest;
    }

    public void process(InputStream output) throws ProcessException {
        try {
            byte buffer[] = new byte[1024];
            int num;
            while ((num = output.read(buffer)) != -1) {
                resetWatchdog();
                dest.write(buffer, 0, num);
            }
        } catch (InterruptedIOException e) {
            // This means the process was asked to stop which can be normal so we just finish
        } catch (IOException e) {
            throw new ProcessException(e);
        }
    }
}
