package com.atlassian.utils.process;

/**
 */
public abstract class BaseOutputHandler implements OutputHandler {
    private Watchdog watchdog;

    public void setWatchdog(Watchdog watchdog) {
        this.watchdog = watchdog;
    }

    protected void resetWatchdog() {
        if (watchdog != null) {
            watchdog.resetWatchdog();
        }
    }

    public void cancelProcess() {
        watchdog.cancel();
    }

    public void complete() throws ProcessException {
    }
}
