/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.util.contentcache.internal.util;

import java.io.IOException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Objects;
import javax.annotation.Nonnull;

public class MoreFiles {
    private MoreFiles() {
        throw new UnsupportedOperationException(this.getClass().getName() + " is a utility class.");
    }

    @Nonnull
    public static Path mkdir(@Nonnull Path directory) {
        Objects.requireNonNull(directory, "directory");
        try {
            return Files.createDirectories(directory, new FileAttribute[0]);
        }
        catch (IOException e) {
            if (e instanceof FileAlreadyExistsException && Files.isDirectory(directory, new LinkOption[0])) {
                return directory;
            }
            throw new IllegalStateException("Could not create " + directory.toAbsolutePath(), e);
        }
    }
}

