/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.util.contentcache.internal;

import com.atlassian.util.contentcache.CacheExpiryStrategy;
import com.atlassian.util.contentcache.internal.AbstractCacheEntry;
import com.atlassian.util.contentcache.internal.util.MoreFiles;
import com.google.common.base.Preconditions;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Date;
import java.util.Queue;
import java.util.concurrent.ArrayBlockingQueue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileCacheEntry
extends AbstractCacheEntry {
    private static final int MAX_CLEANUP_QUEUE = 50;
    private static final Queue<Path> cleanupQueue = new ArrayBlockingQueue<Path>(50);
    private static final Logger log = LoggerFactory.getLogger(FileCacheEntry.class);
    private final Path cacheDir;
    private volatile Path cacheFile;

    public FileCacheEntry(@Nonnull String cacheKey, @Nonnull String cacheRegion, @Nonnull File cacheDir, @Nullable Date expiry, @Nonnull CacheExpiryStrategy expiryStrategy) {
        this(cacheKey, cacheRegion, expiry, expiryStrategy, ((File)Preconditions.checkNotNull((Object)cacheDir, (Object)"cacheDir")).toPath());
    }

    public FileCacheEntry(@Nonnull String cacheKey, @Nonnull String cacheRegion, @Nullable Date expiry, @Nonnull CacheExpiryStrategy expiryStrategy, @Nonnull Path cacheDir) {
        super(cacheKey, cacheRegion, expiry, expiryStrategy);
        this.cacheDir = (Path)Preconditions.checkNotNull((Object)cacheDir, (Object)"cacheDir");
    }

    public static void processCleanupQueue() {
        FileCacheEntry.doCleanupCacheFile(cleanupQueue.poll());
    }

    @Override
    public boolean isValid() {
        return super.isValid() && (this.cacheFile == null || Files.exists(this.cacheFile, new LinkOption[0]));
    }

    @Override
    protected void doCleanup() {
        FileCacheEntry.doCleanupCacheFile(this.cacheFile);
    }

    @Override
    @Nonnull
    protected InputStream doCreateCacheInputStream() throws IOException {
        Preconditions.checkState((this.cacheFile != null ? 1 : 0) != 0, (Object)"Cache file hasn't been created yet");
        return Files.newInputStream(this.cacheFile, new OpenOption[0]);
    }

    @Override
    @Nonnull
    protected OutputStream doCreateCacheOutputStream() throws IOException {
        Preconditions.checkState((this.cacheFile == null ? 1 : 0) != 0, (Object)"Cache file has already been created");
        this.cacheFile = this.createCacheFile();
        return Files.newOutputStream(this.cacheFile, new OpenOption[0]);
    }

    private static void doCleanupCacheFile(Path cacheFile) {
        if (cacheFile == null) {
            return;
        }
        try {
            Files.delete(cacheFile);
        }
        catch (FileNotFoundException | NoSuchFileException iOException) {
        }
        catch (IOException e) {
            if (cleanupQueue.offer(cacheFile)) {
                log.warn("Failed to delete {}, retrying later", (Object)cacheFile.toAbsolutePath(), (Object)e);
            }
            log.error("Failed to delete {}", (Object)cacheFile.toAbsolutePath(), (Object)e);
        }
    }

    private void createCacheDir() {
        try {
            MoreFiles.mkdir(this.cacheDir);
        }
        catch (IllegalStateException e) {
            log.warn("Could not create cache directory {}", (Object)this.cacheDir.toAbsolutePath(), (Object)e);
        }
    }

    private Path createCacheFile() throws IOException {
        this.createCacheDir();
        return Files.createTempFile(this.cacheDir, "cache-entry", "", new FileAttribute[0]);
    }
}

