/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.util.contentcache;

import com.atlassian.util.contentcache.StreamPump;
import com.atlassian.util.contentcache.StreamPumper;
import com.google.common.base.Preconditions;
import java.util.Iterator;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BackgroundThreadStreamPumper
implements StreamPumper {
    private static final Logger log = LoggerFactory.getLogger(BackgroundThreadStreamPumper.class);
    private final Queue<StreamPump> pumps = new ConcurrentLinkedQueue<StreamPump>();
    private final Thread pumpThread;
    private volatile boolean shutdown;

    public BackgroundThreadStreamPumper(String name) {
        this.pumpThread = new Thread((Runnable)new PumpSomeTask(), name);
        this.pumpThread.setDaemon(true);
        this.pumpThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean add(@Nonnull StreamPump pump) {
        if (!this.shutdown && !this.pumps.contains(pump) && this.pumps.add((StreamPump)Preconditions.checkNotNull((Object)pump, (Object)"pump"))) {
            Queue<StreamPump> queue = this.pumps;
            synchronized (queue) {
                this.pumps.notifyAll();
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean remove(@Nonnull StreamPump pump) {
        return this.pumps.remove(Preconditions.checkNotNull((Object)pump, (Object)"pump"));
    }

    @Override
    public void shutdown() {
        if (!this.shutdown) {
            this.shutdown = true;
            if (this.pumpThread.isAlive()) {
                try {
                    this.pumpThread.interrupt();
                    this.pumpThread.join(1000L);
                    if (this.pumpThread.isAlive()) {
                        log.warn("Timed out waiting for the background pump thread to shutdown");
                    }
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    log.debug("StreamPump interrupted on shutdown");
                }
            }
        }
    }

    private class PumpSomeTask
    implements Runnable {
        private PumpSomeTask() {
        }

        @Override
        public void run() {
            while (!BackgroundThreadStreamPumper.this.shutdown) {
                this.waitIfEmpty();
                boolean pumpedSomething = false;
                Iterator it = BackgroundThreadStreamPumper.this.pumps.iterator();
                while (!BackgroundThreadStreamPumper.this.shutdown && it.hasNext()) {
                    StreamPump task = (StreamPump)it.next();
                    if (task.isDone()) {
                        log.trace("Removing pump task from list of pumps");
                        it.remove();
                        continue;
                    }
                    try {
                        pumpedSomething = task.maybePumpSome() || pumpedSomething;
                    }
                    catch (Exception e) {
                        log.info("Error pumping a stream. Removing it from the list of pumps");
                        log.debug("Pumping error", (Throwable)e);
                        it.remove();
                    }
                }
                if (pumpedSomething || BackgroundThreadStreamPumper.this.pumps.isEmpty()) continue;
                try {
                    Thread.sleep(3L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void waitIfEmpty() {
            if (!BackgroundThreadStreamPumper.this.pumps.isEmpty()) {
                return;
            }
            Queue queue = BackgroundThreadStreamPumper.this.pumps;
            synchronized (queue) {
                if (!BackgroundThreadStreamPumper.this.pumps.isEmpty()) {
                    return;
                }
                try {
                    BackgroundThreadStreamPumper.this.pumps.wait();
                }
                catch (InterruptedException e) {
                    log.debug("Background stream pump was interrupted. Exiting");
                    Thread.currentThread().interrupt();
                }
            }
        }
    }
}

