/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.util.concurrent;

import com.atlassian.util.concurrent.LazyReference;
import com.atlassian.util.concurrent.Supplier;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public abstract class ResettableLazyReference<T>
implements Supplier<T> {
    private static final AtomicReferenceFieldUpdater<ResettableLazyReference, InternalReference> updater = AtomicReferenceFieldUpdater.newUpdater(ResettableLazyReference.class, InternalReference.class, "referrent");
    private volatile InternalReference<T> referrent = new InternalReference(this);

    protected abstract T create() throws Exception;

    @Override
    public T get() {
        return this.referrent.get();
    }

    public final T getInterruptibly() throws InterruptedException {
        return this.referrent.getInterruptibly();
    }

    public Supplier<T> reset() {
        Supplier result = updater.getAndSet(this, new InternalReference(this));
        return result;
    }

    public boolean isInitialized() {
        return this.referrent.isInitialized();
    }

    public void cancel() {
        this.referrent.cancel();
    }

    static class InternalReference<T>
    extends LazyReference<T> {
        private final ResettableLazyReference<T> ref;

        InternalReference(ResettableLazyReference<T> ref) {
            this.ref = ref;
        }

        @Override
        protected T create() throws Exception {
            return this.ref.create();
        }
    }
}

