/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.util.concurrent;

import com.atlassian.util.concurrent.Effect;
import com.atlassian.util.concurrent.Promise;
import com.atlassian.util.concurrent.Promises;
import com.google.common.base.Function;
import com.google.common.util.concurrent.AbstractFuture;
import com.google.common.util.concurrent.FutureCallback;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Deferred<V>
extends AbstractFuture<V>
implements Promise<V> {
    private Promise<V> promise = Promises.forListenableFuture(this);

    private Deferred() {
    }

    public Deferred<V> resolve(V value) {
        this.set(value);
        return this;
    }

    public Deferred<V> reject(Throwable t) {
        this.setException(t);
        return this;
    }

    public Promise<V> promise() {
        return this.promise;
    }

    public static <V> Deferred<V> create() {
        return new Deferred<V>();
    }

    @Override
    public V claim() {
        return this.promise.claim();
    }

    @Override
    public Deferred<V> done(Effect<V> callback) {
        this.promise.done(callback);
        return this;
    }

    @Override
    public Deferred<V> fail(Effect<Throwable> callback) {
        this.promise.fail(callback);
        return this;
    }

    @Override
    public Deferred<V> on(FutureCallback<V> callback) {
        this.promise.on(callback);
        return this;
    }

    @Override
    public <T> Promise<T> map(Function<? super V, ? extends T> function) {
        return this.promise.map(function);
    }

    @Override
    public <T> Promise<T> flatMap(Function<? super V, Promise<T>> function) {
        return this.promise.flatMap(function);
    }
}

