/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.util.concurrent;

import com.atlassian.util.concurrent.Assertions;
import com.atlassian.util.concurrent.Function;
import com.atlassian.util.concurrent.NotNull;
import com.google.common.base.Supplier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Functions {
    public static <D, R> Function<D, R> fromSupplier(@NotNull Supplier<R> supplier) {
        return new FromSupplier(supplier);
    }

    static <T> Function<Supplier<? extends T>, T> fromSupplier() {
        return new ValueExtractor();
    }

    public static <T> Function<T, T> identity() {
        return new Identity();
    }

    static <T> Function<Supplier<T>, Supplier<T>> ignoreExceptions() {
        return new ExceptionIgnorer();
    }

    public static <T, R> com.google.common.base.Function<T, R> toGoogleFunction(Function<T, R> function) {
        return new ToGoogleAdapter<T, R>(function);
    }

    private Functions() {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ToGoogleAdapter<T, R>
    implements com.google.common.base.Function<T, R> {
        private final Function<T, R> delegate;

        ToGoogleAdapter(Function<T, R> delegate) {
            this.delegate = delegate;
        }

        public R apply(T from) {
            return this.delegate.get(from);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class IgnoreAndReturnNull<T>
    implements Supplier<T> {
        private final Supplier<T> delegate;

        IgnoreAndReturnNull(Supplier<T> delegate) {
            this.delegate = Assertions.notNull("delegate", delegate);
        }

        public T get() {
            try {
                return (T)this.delegate.get();
            }
            catch (RuntimeException ignore) {
                return null;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ExceptionIgnorer<T>
    implements Function<Supplier<T>, Supplier<T>> {
        ExceptionIgnorer() {
        }

        @Override
        public Supplier<T> get(Supplier<T> from) {
            return new IgnoreAndReturnNull<T>(from);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Identity<T>
    implements Function<T, T> {
        private Identity() {
        }

        @Override
        public T get(T input) {
            return input;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ValueExtractor<T>
    implements Function<Supplier<? extends T>, T> {
        private ValueExtractor() {
        }

        @Override
        public T get(Supplier<? extends T> supplier) {
            return (T)supplier.get();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FromSupplier<D, R>
    implements Function<D, R> {
        private final Supplier<R> supplier;

        FromSupplier(Supplier<R> supplier) {
            this.supplier = Assertions.notNull("supplier", supplier);
        }

        @Override
        public R get(D input) {
            return (R)this.supplier.get();
        }
    }
}

