/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.util.concurrent;

import com.atlassian.util.concurrent.Assertions;
import com.atlassian.util.concurrent.NotNull;
import com.google.common.base.Function;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class WeakMemoizer<K, V>
implements Function<K, V> {
    private final ConcurrentMap<K, MappedReference<K, V>> map;
    private final ReferenceQueue<V> queue = new ReferenceQueue();
    private final Function<K, V> delegate;

    static <K, V> WeakMemoizer<K, V> weakMemoizer(Function<K, V> delegate) {
        return new WeakMemoizer<K, V>(delegate);
    }

    WeakMemoizer(@NotNull Function<K, V> delegate) {
        this.map = new ConcurrentHashMap<K, MappedReference<K, V>>();
        this.delegate = Assertions.notNull("delegate", delegate);
    }

    public V apply(K descriptor) {
        this.expungeStaleEntries();
        Assertions.notNull("descriptor", descriptor);
        while (true) {
            MappedReference reference;
            if ((reference = (MappedReference)this.map.get(descriptor)) != null) {
                Object value = reference.get();
                if (value != null) {
                    return (V)value;
                }
                this.map.remove(descriptor, reference);
            }
            this.map.putIfAbsent(descriptor, new MappedReference<K, Object>(descriptor, this.delegate.apply(descriptor), this.queue));
        }
    }

    private void expungeStaleEntries() {
        MappedReference ref;
        while ((ref = (MappedReference)this.queue.poll()) != null) {
            Object key = ref.getDescriptor();
            if (key == null) continue;
            this.map.remove(key, ref);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class MappedReference<K, V>
    extends WeakReference<V> {
        private final K key;

        public MappedReference(K key, V value, ReferenceQueue<? super V> q) {
            super(Assertions.notNull("value", value), q);
            this.key = Assertions.notNull("key", key);
        }

        final K getDescriptor() {
            return this.key;
        }
    }
}

