/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.util.concurrent;

import com.atlassian.util.concurrent.TimedOutException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicMarkableReference;
import net.jcip.annotations.ThreadSafe;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public class SettableFuture<T>
implements Future<T> {
    private volatile AtomicMarkableReference<T> ref = new AtomicMarkableReference<Object>(null, false);
    private final CountDownLatch latch = new CountDownLatch(1);

    public void set(T value) {
        boolean[] mark = new boolean[1];
        do {
            T oldValue = this.ref.get(mark);
            if (!mark[0]) continue;
            if (!this.equals(oldValue, value)) {
                throw new IllegalArgumentException("cannot change value after it has been set");
            }
            return;
        } while (!this.ref.compareAndSet(null, value, false, true));
        this.latch.countDown();
    }

    @Override
    public T get() throws InterruptedException {
        this.latch.await();
        return this.ref.getReference();
    }

    @Override
    public T get(long timeout, TimeUnit unit) throws InterruptedException, TimeoutException {
        if (!this.latch.await(timeout, unit)) {
            throw new TimedOutException(timeout, unit);
        }
        return this.ref.getReference();
    }

    @Override
    public boolean isDone() {
        return this.ref.getReference() != null;
    }

    @Override
    public boolean isCancelled() {
        return false;
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        return false;
    }

    private boolean equals(T one, T two) {
        if (one == null) {
            return two == null;
        }
        return one.equals(two);
    }
}

