/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.util.concurrent;

import com.atlassian.util.concurrent.Function;
import com.atlassian.util.concurrent.LockManager;
import com.atlassian.util.concurrent.WeakLockMap;
import java.util.concurrent.Callable;
import java.util.concurrent.locks.Lock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LockManagers {
    public static <T, D> LockManager<T> weakLockManager(Function<T, D> stripeFunction) {
        return LockManagers.weakLockManager(stripeFunction, 128);
    }

    public static <T, D> LockManager<T> weakLockManager(Function<T, D> stripeFunction, int initialCapacity) {
        return new Manager<T, D>(new WeakLockMap(initialCapacity), stripeFunction);
    }

    private LockManagers() {
        throw new AssertionError((Object)"cannot instantiate!");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Manager<T, D>
    implements LockManager<T> {
        private final Function<D, Lock> lockResolver;
        private final Function<T, D> stripeFunction;

        Manager(Function<D, Lock> lockResolver, Function<T, D> stripeFunction) {
            this.lockResolver = lockResolver;
            this.stripeFunction = stripeFunction;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public <R> R withLock(T descriptor, Callable<R> callable) throws Exception {
            Lock lock = this.lockResolver.get(this.stripeFunction.get(descriptor));
            lock.lock();
            try {
                R r = callable.call();
                return r;
            }
            finally {
                lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void withLock(T descriptor, Runnable runnable) {
            Lock lock = this.lockResolver.get(this.stripeFunction.get(descriptor));
            lock.lock();
            try {
                runnable.run();
            }
            finally {
                lock.unlock();
            }
        }
    }

    private static final class Defaults {
        private static final int CAPACITY = 128;

        private Defaults() {
        }
    }
}

