/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.util.concurrent;

import com.atlassian.util.concurrent.CopyOnWriteMap;
import com.atlassian.util.concurrent.CopyOnWriteSortedMap;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CopyOnWriteMaps {
    public static <K, V> CopyOnWriteMap<K, V> newHashMap() {
        return new CopyOnWriteMap<K, V>(){
            private static final long serialVersionUID = 5221824943734164497L;

            @Override
            public <N extends Map<? extends K, ? extends V>> Map<K, V> copy(N map) {
                return new HashMap(map);
            }
        };
    }

    public static <K, V> CopyOnWriteMap<K, V> newHashMap(Map<? extends K, ? extends V> map) {
        return new CopyOnWriteMap<K, V>((Map)map){
            private static final long serialVersionUID = -7616159260882572421L;

            @Override
            public <N extends Map<? extends K, ? extends V>> Map<K, V> copy(N map) {
                return new HashMap(map);
            }
        };
    }

    public static <K, V> CopyOnWriteMap<K, V> newLinkedMap() {
        return new CopyOnWriteMap<K, V>(){
            private static final long serialVersionUID = -4597421704607601676L;

            @Override
            public <N extends Map<? extends K, ? extends V>> Map<K, V> copy(N map) {
                return new LinkedHashMap(map);
            }
        };
    }

    public static <K, V> CopyOnWriteMap<K, V> newLinkedMap(Map<? extends K, ? extends V> map) {
        return new CopyOnWriteMap<K, V>((Map)map){
            private static final long serialVersionUID = -8659999465009072124L;

            @Override
            public <N extends Map<? extends K, ? extends V>> Map<K, V> copy(N map) {
                return new LinkedHashMap(map);
            }
        };
    }

    public static <K, V> CopyOnWriteSortedMap<K, V> newTreeMap() {
        return new CopyOnWriteSortedMap<K, V>(){
            private static final long serialVersionUID = 8015823768891873357L;

            @Override
            public <N extends Map<? extends K, ? extends V>> SortedMap<K, V> copy(N map) {
                return new TreeMap(map);
            }
        };
    }

    public static <K, V> CopyOnWriteSortedMap<K, V> newTreeMap(Map<? extends K, ? extends V> map) {
        return new CopyOnWriteSortedMap<K, V>(){
            private static final long serialVersionUID = 6065245106313875871L;

            @Override
            public <N extends Map<? extends K, ? extends V>> SortedMap<K, V> copy(N map) {
                return new TreeMap(map);
            }
        };
    }

    public static <K, V> CopyOnWriteSortedMap<K, V> newTreeMap(final Comparator<? super K> comparator) {
        return new CopyOnWriteSortedMap<K, V>(){
            private static final long serialVersionUID = -7243810284130497340L;

            @Override
            public <N extends Map<? extends K, ? extends V>> SortedMap<K, V> copy(N map) {
                TreeMap treeMap = new TreeMap(comparator);
                treeMap.putAll(map);
                return treeMap;
            }
        };
    }

    public static <K, V> CopyOnWriteSortedMap<K, V> newTreeMap(Map<? extends K, ? extends V> map, final Comparator<? super K> comparator) {
        return new CopyOnWriteSortedMap<K, V>(){
            private static final long serialVersionUID = -6016130690072425548L;

            @Override
            public <N extends Map<? extends K, ? extends V>> SortedMap<K, V> copy(N map) {
                TreeMap treeMap = new TreeMap(comparator);
                treeMap.putAll(map);
                return treeMap;
            }
        };
    }
}

