/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.util.concurrent;

import com.atlassian.util.concurrent.AbstractCopyOnWriteMap;
import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import net.jcip.annotations.ThreadSafe;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public class CopyOnWriteMap<K, V>
extends AbstractCopyOnWriteMap<K, V, Map<K, V>>
implements Map<K, V>,
Serializable {
    private static final long serialVersionUID = 7935514534647505917L;

    static <K, V> CopyOnWriteMap<K, V> newHashMap() {
        return new CopyOnWriteMap(Functions.hash());
    }

    static <K, V> CopyOnWriteMap<K, V> newHashMap(Map<K, V> map) {
        return new CopyOnWriteMap<K, V>(map, Functions.hash());
    }

    static <K, V> CopyOnWriteMap<K, V> newLinkedMap() {
        return new CopyOnWriteMap(Functions.linked());
    }

    static <K, V> CopyOnWriteMap<K, V> newLinkedMap(Map<K, V> map) {
        return new CopyOnWriteMap<K, V>(map, Functions.linked());
    }

    public CopyOnWriteMap(Map<K, V> map, CopyFunction<Map<K, V>> factory) {
        super(map, factory);
    }

    public CopyOnWriteMap(CopyFunction<Map<K, V>> factory) {
        super(new HashMap(), factory);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Functions {
        public static <K, V> CopyFunction<Map<K, V>> hash() {
            return new CopyFunction<Map<K, V>>(){

                @Override
                public Map<K, V> copy(Map<K, V> map) {
                    return new HashMap(map);
                }
            };
        }

        public static <K, V> CopyFunction<Map<K, V>> linked() {
            return new CopyFunction<Map<K, V>>(){

                @Override
                public Map<K, V> copy(Map<K, V> map) {
                    return new LinkedHashMap(map);
                }
            };
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface CopyFunction<M extends Map<?, ?>>
    extends AbstractCopyOnWriteMap.CopyFunction<M> {
    }
}

