package com.atlassian.user.util.migration;

import org.slf4j.Logger;

public class Slf4jMigrationProgressListener implements MigrationProgressListener
{
    private final Logger logger;

    private int usersToMigrate;

    private int usersMigrated = 0;

    private int groupsToMigrate;

    private int groupsMigrated = 0;

    public Slf4jMigrationProgressListener(final Logger logger)
    {
        if (logger == null)
            throw new IllegalArgumentException("Logger must NOT be null");
        this.logger = logger;
    }

    public void userMigrationStarted(int usersToMigrate)
    {
        this.usersToMigrate = usersToMigrate;
        logger.info("Starting user migration. {} users to migrate.", usersToMigrate);
    }

    public void userMigrated()
    {
        if (++usersMigrated % 100 == 0)
        {
            logger.info("{} users migrated out of {}.", usersMigrated, usersToMigrate);
        }
    }

    public void userMigrationComplete()
    {
        logger.info("User migration complete.");
    }

    public void groupMigrationStarted(int groupsToMigrate)
    {
        this.groupsToMigrate = groupsToMigrate;
        logger.info("Group migration started. {} groups to migrate.", groupsToMigrate);
    }

    public void groupMigrated()
    {
        if (++groupsMigrated % 10 == 0)
        {
            logger.info("{} groups migrated out of {}.", groupsMigrated, groupsToMigrate);
        }
    }

    public void groupMigrationComplete()
    {
        logger.info("Group migration complete.");
    }

    public void readonlyGroupMembershipNotMigrated(String groupName, String userName)
    {
        logger.warn("Could not migrate group membership for user <{}> and group <{}>. " +
                "Group is read-only; it is possibly a LDAP group.", userName, groupName);
    }
}
