package com.atlassian.user.util;

/**
 * Sets up default config. values for LDAP if they have not been set elsewhere.
 */

import org.apache.log4j.Logger;

import java.util.Properties;

public class LDAPConnectionPoolUtils
{
    private static final Logger log = Logger.getLogger(LDAPConnectionPoolUtils.class);

    private static boolean initialized;
    public final static String POOL_MAX = "com.sun.jndi.ldap.connect.pool.maxsize";
    public final static String POOL_INITSIZE = "com.sun.jndi.ldap.connect.pool.initsize";
    public final static String POOL_PREFSIZE = "com.sun.jndi.ldap.connect.pool.prefsize";
    public final static String POOL_DEBUG = "com.sun.jndi.ldap.connect.pool.debug";
    public final static String POOL_PROTOCOL = "com.sun.jndi.ldap.connect.pool.protocol";
    public final static String POOL_AUTH = "com.sun.jndi.ldap.connect.pool.authentication";
    public final static String POOL_TIMEOUT = "com.sun.jndi.ldap.connect.pool.timeout";

    private static Properties connectionPoolProperties = null;

    public static Properties getConnectionPoolProperties()
    {
        if (connectionPoolProperties == null)
            connectionPoolProperties = new Properties();
        else
            return connectionPoolProperties;

        if (connectionPoolProperties.getProperty(POOL_MAX) == null)
            connectionPoolProperties.setProperty(POOL_MAX, "10");

        if (connectionPoolProperties.getProperty(POOL_INITSIZE) == null)
            connectionPoolProperties.setProperty(POOL_INITSIZE, "10");

        if (connectionPoolProperties.getProperty(POOL_PREFSIZE) == null)
            connectionPoolProperties.setProperty(POOL_PREFSIZE, "10");

        if (connectionPoolProperties.getProperty(POOL_DEBUG) == null)
            connectionPoolProperties.setProperty(POOL_DEBUG, "fine");

        if (connectionPoolProperties.getProperty(POOL_PROTOCOL) == null)
            connectionPoolProperties.setProperty(POOL_PROTOCOL, "plain ssl");

        if (connectionPoolProperties.getProperty(POOL_AUTH) == null)
            connectionPoolProperties.setProperty(POOL_AUTH, "none simple DIGEST-MD5");

        if (connectionPoolProperties.getProperty(POOL_TIMEOUT) == null)
            connectionPoolProperties.setProperty(POOL_TIMEOUT, "3000000");

        return connectionPoolProperties;
    }
}
